package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.CustomsPayment;
import com.xforceplus.ultraman.app.openapirapi.service.ICustomsPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-18
 */
@RestController
public class CustomsPaymentController {

  @Autowired
  private ICustomsPaymentService customsPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsPayment ${table.comment}
   * @return
   */
  @GetMapping("/customspayments" )
  public XfR getCustomsPayments(XfPage page, CustomsPayment customsPayment) {
    return XfR.ok(customsPaymentServiceImpl.page(page, Wrappers.query(customsPayment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customspayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsPaymentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customsPayment ${table.comment}
   * @return XfR
   */
  @PostMapping("/customspayments")
  public XfR save(@RequestBody CustomsPayment customsPayment) {
     return XfR.ok(customsPaymentServiceImpl.save(customsPayment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customsPayment ${table.comment}
   * @return XfR
   */
  @PutMapping("/customspayments/{id}")
  public XfR putUpdate(@RequestBody CustomsPayment customsPayment,@PathVariable Long id) {
      customsPayment.setId(id);
      return XfR.ok(customsPaymentServiceImpl.updateById(customsPayment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customsPayment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customspayments/{id}")
  public XfR patchUpdate(@RequestBody CustomsPayment customsPayment,@PathVariable Long id) {
      CustomsPayment upcustomsPayment = customsPaymentServiceImpl.getById(id);
      if(upcustomsPayment != null){
        upcustomsPayment = ObjectCopyUtils.copyProperties(customsPayment,upcustomsPayment,true);
      }
      return XfR.ok(customsPaymentServiceImpl.updateById(upcustomsPayment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customspayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/customspayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_payment");
     params.put("request", condition);

     return XfR.ok(customsPaymentServiceImpl.querys(params));
  }

}
