package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.InvoiceSendStatisticAuth;
import com.xforceplus.ultraman.app.openapirapi.service.IInvoiceSendStatisticAuthService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-18
 */
@RestController
public class InvoiceSendStatisticAuthController {

  @Autowired
  private IInvoiceSendStatisticAuthService invoiceSendStatisticAuthServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSendStatisticAuth ${table.comment}
   * @return
   */
  @GetMapping("/invoicesendstatisticauths" )
  public XfR getInvoiceSendStatisticAuths(XfPage page, InvoiceSendStatisticAuth invoiceSendStatisticAuth) {
    return XfR.ok(invoiceSendStatisticAuthServiceImpl.page(page, Wrappers.query(invoiceSendStatisticAuth)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicesendstatisticauths/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSendStatisticAuthServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSendStatisticAuth ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicesendstatisticauths")
  public XfR save(@RequestBody InvoiceSendStatisticAuth invoiceSendStatisticAuth) {
     return XfR.ok(invoiceSendStatisticAuthServiceImpl.save(invoiceSendStatisticAuth));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSendStatisticAuth ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicesendstatisticauths/{id}")
  public XfR putUpdate(@RequestBody InvoiceSendStatisticAuth invoiceSendStatisticAuth,@PathVariable Long id) {
      invoiceSendStatisticAuth.setId(id);
      return XfR.ok(invoiceSendStatisticAuthServiceImpl.updateById(invoiceSendStatisticAuth));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSendStatisticAuth ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicesendstatisticauths/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSendStatisticAuth invoiceSendStatisticAuth,@PathVariable Long id) {
      InvoiceSendStatisticAuth upinvoiceSendStatisticAuth = invoiceSendStatisticAuthServiceImpl.getById(id);
      if(upinvoiceSendStatisticAuth != null){
        upinvoiceSendStatisticAuth = ObjectCopyUtils.copyProperties(invoiceSendStatisticAuth,upinvoiceSendStatisticAuth,true);
      }
      return XfR.ok(invoiceSendStatisticAuthServiceImpl.updateById(upinvoiceSendStatisticAuth));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicesendstatisticauths/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSendStatisticAuthServiceImpl.removeById(id));
  }

  @PostMapping("/invoicesendstatisticauths/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_send_statistic_auth");
     params.put("request", condition);

     return XfR.ok(invoiceSendStatisticAuthServiceImpl.querys(params));
  }

}
