package com.xforceplus.ultraman.app.phoenixcustomerselfops.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-10-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixcustomerselfops.entity.BillUploadLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "phoenix-customer-self-ops")
public interface BillUploadLogFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/billUploadLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param billUploadLog ${table.comment}
   * @return R
   */
  @PostMapping("/billUploadLog/add")
  public R save(@RequestBody BillUploadLog billUploadLog);

  /**
   * 修改${table.comment}
   * @param billUploadLog ${table.comment}
   * @return R
   */
  @PostMapping("/billUploadLog/update")
  public R updateById(@RequestBody BillUploadLog billUploadLog);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/billUploadLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}