/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.phoenixcustomerselfops.metadata.validator;

import com.xforceplus.ultraman.app.phoenixcustomerselfops.metadata.validator.annotation.CheckUltramanBool;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UltramanBoolConstraintValidator
implements ConstraintValidator<CheckUltramanBool, String> {
    private final String MSG_FORMAT = "value must be 'true' or 'false' ";
    private final String TRUE_STR = "true";
    private final String FALSE_STR = "false";

    public void initialize(CheckUltramanBool constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || value.length() == 0) {
            return true;
        }
        boolean isValid = Arrays.asList("true", "false").contains(value);
        if (!isValid) {
            this.unValidMsg(context);
        }
        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("value must be 'true' or 'false' ", new Object[0])).addConstraintViolation();
    }
}

