package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 特殊发票标记
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum SpecialInvoiceFlag {

    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务"),
    _07("07", "代收车船税"),
    _09("09", "旅客运输服务"),
    _10("10", "医疗服务"),
    _13("13", "拖拉机和联合收割机");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code) {
        return Stream.of(SpecialInvoiceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
