package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据来源的平台
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum Source {

    _2("2", "协同平台"),
    _3("3", "3.0平台"),
    _4("4", "4.0平台"),
    PURCHASER("purchaser", "4.0进项"),
    IMAGE("image", "影像系统");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Source(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Source fromCode(String code) {
        return Stream.of(Source.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
