package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 运输工具种类
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public enum TransportationType {

    _01("01", "铁路运输"),
    _02("02", "公路运输"),
    _03("03", "水路运输"),
    _04("04", "航空运输"),
    _05("05", "管道运输");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TransportationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransportationType fromCode(String code) {
        return Stream.of(TransportationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
