package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Invoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 批次号
   */
  private Long batchNo;
  /**
   * 系统外批次号  默认batch_no的值
   */
  private Long outBatchNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 销方集团id
   */
  private Long sellerGroupId;
  /**
   * 销方租户id
   */
  private Long sellerTenantId;
  /**
   * 销方租户公司编号
   */
  private String sellerNo;
  /**
   * 销方组织ID
   */
  private Long sellerId;
  /**
   * 销方代码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方纳税人识别号
   */
  private String sellerTaxNo;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方集团id
   */
  private Long purchaserGroupId;
  /**
   * 购方租户id
   */
  private Long purchaserTenantId;
  /**
   * 购方组织ID
   */
  private Long purchaserId;
  /**
   * 购方租户公司编号
   */
  private String purchaserNo;
  /**
   * 购方纳税人识别号
   */
  private String purchaserTaxNo;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 购方电子支付标识
   */
  private String purchaserEPayId;
  /**
   * 红蓝标识 1-蓝票 2-红票 3-红冲票
   */
  private String invoiceColor;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;
  /**
   * check_code
   */
  private String checkCode;
  /**
   * 收款人姓名
   */
  private String cashierName;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 备注
   */
  private String remark;
  /**
   * 电子签名
   */
  private String electronicSignature;
  /**
   * 发票来源方 0-4.0平台 1-协同平台
   */
  private String invoiceFrom;
  /**
   * 系统来源 下发数据需要  由属地直接传过来
   */
  private String systemOrig;
  /**
   * 单据类型
   */
  private String billType;
  /**
   * 适用业务单据类型
   */
  private String businessBillType;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 原蓝票的开票日期
   */
  private String originPaperDrawDate;
  /**
   * 原发票类型
   */
  private String originInvoiceType;
  /**
   * 查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
   */
  private Long veriStatus;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 二维密文
   */
  private String cipherTextTwoCode;
  /**
   * 虚拟标志
   */
  private String virtualFlag;
  /**
   * 作废标识 0-默认 1-批次内 2-批次外
   */
  private String abandonFlag;
  /**
   * 红冲时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redTime;
  /**
   * 红冲人id
   */
  private Long redUserId;
  /**
   * 红冲人姓名
   */
  private String redUserName;
  /**
   * 0-正常, 1-待红冲, 2-待部分红冲, 3-已红冲, 4-已部分红冲, 5-红冲票
   */
  private Long redFlag;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 发票状态1-正常 0-作废 2-待处理
   */
  private Long status;
  /**
   * 阳光城-生成凭证后锁定、解锁标志  0-解锁  1-锁定
   */
  private Long matchedStatus;
  /**
   * 销货清单文件打印标志（0-否,1-是）默认0
   */
  private Long saleListFileFlag;
  /**
   * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
   */
  private Long printContentFlag;
  /**
   * ofd路径
   */
  private String ofdPath;
  /**
   * pdf路径
   */
  private String pdfPath;
  /**
   * 接收方邮箱
   */
  private String receiveUserEmail;
  /**
   * 开票点名称
   */
  private String makeOutUnitName;
  /**
   * 处理状态 1-正常  2-处理中 3-业务系统红冲 4-业务系统作废 5-进项退回
   */
  private String handleStatus;
  /**
   * 处理备注
   */
  private String handleRemark;
  /**
   * 外部批次生成标志 1-不生成 0-生成
   */
  private String outCheckStatus;
  /**
   * 系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
   */
  private String outLockConfig;
  /**
   * 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出
   */
  private String identifyStatus;
  /**
   * 打印状态1-已打印 0-未打印
   */
  private String printStatus;
  /**
   * 退票状态 0-未退(默认) 1-已退
   */
  private String retreatStatus;
  /**
   * 付款状态 0-未付款(默认) 1-部分付款 2-已付款
   */
  private String paymentStatus;
  /**
   * 终端类型 1-单盘 2-服务器 4-区块链
   */
  private Long terminalType;
  /**
   * 作废的人名字
   */
  private String deposeUserName;
  /**
   * 作废时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deposeTime;
  /**
   * 作废操作账号
   */
  private Long deposeUserId;
  /**
   * 权限ID
   */
  private Long sysOrgId;
  /**
   * 发票影像的URL
   */
  private String invoiceUrl;
  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   */
  private Long mergeType;
  /**
   * 用户ID下发数据需要,由属地直接传过来
   */
  private String customerNo;
  /**
   * 锁定状态 0-未锁定;1-页面锁定;2-作废锁;3-打印锁;4-红冲锁;
   */
  private Long lockFlag;
  /**
   * 物流 收件人
   */
  private String addressee;
  /**
   * 物流-收件人电话
   */
  private String addresseeTel;
  /**
   * 物流-收件人省份
   */
  private String addresseeProvince;
  /**
   * 物流-收件人城市
   */
  private String addresseeCity;
  /**
   * 物流-收件人所在县区
   */
  private String addresseeCounty;
  /**
   * 物流-收件人地址
   */
  private String direction;
  /**
   * 物流备注
   */
  private String logisticRemark;
  /**
   * 收件人所在单位
   */
  private String addresseeComp;
  /**
   * 收件人邮编
   */
  private String addresseePost;
  /**
   * 物流状态 1-待寄送 3-寄送中
   */
  private Long businessLgtStatus;
  /**
   * 审批流程id
   */
  private String procInstId;
  /**
   * 0:正常 1:红冲 2:作废
   */
  private Long auditType;
  /**
   * 开票机号
   */
  private String diskNo;
  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  private Long systemOrigType;
  /**
   * 电子数据同步时间
   */
  private Long electronicDataSyncTime;
  /**
   * 销方银行信息
   */
  private String sellerBankInfo;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 购方银行信息
   */
  private String purchaserBankInfo;
  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;
  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   */
  private String makingReason;
  /**
   * 开票方式 0-否 1-是
   */
  private Long makeType;
  /**
   * 接收方电话
   */
  private String receiveUserTel;
  /**
   * 发票票种 s-纸专; se-电专; c-纸普; ce-电普; v-机动车; vs-二手机动车; ju-卷票
   */
  private String invoiceKind;
  /**
   * 税控发票来源 qd-全电发票 sk-税控发票
   */
  private String taxInvoiceSource;
  /**
   * xml地址
   */
  private String xmlUrl;
  /**
   * 渠道
   */
  private String channel;
  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 来源
   */
  private String source;
  /**
   * 发票ID
   */
  private String invoiceId;
  /**
   * 特殊发票标记
   */
  private String specialInvoiceFlag;
  /**
   * 销方租户Code
   */
  private String sellerTenantCode;
  /**
   * 购方租户Code
   */
  private String purchaserTenantCode;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("batchNo", batchNo);
      map.put("outBatchNo", outBatchNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerNo", sellerNo);
      map.put("sellerId", sellerId);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserName", purchaserName);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserId", purchaserId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserEPayId", purchaserEPayId);
      map.put("invoiceColor", invoiceColor);
      map.put("invoiceType", invoiceType);
      map.put("machineCode", machineCode);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("checkCode", checkCode);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("remark", remark);
      map.put("electronicSignature", electronicSignature);
      map.put("invoiceFrom", invoiceFrom);
      map.put("systemOrig", systemOrig);
      map.put("billType", billType);
      map.put("businessBillType", businessBillType);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("originInvoiceType", originInvoiceType);
      map.put("veriStatus", veriStatus);
      map.put("cipherText", cipherText);
      map.put("cipherTextTwoCode", cipherTextTwoCode);
      map.put("virtualFlag", virtualFlag);
      map.put("abandonFlag", abandonFlag);
      map.put("redTime", BocpGenUtils.toTimestamp(redTime));
      map.put("redUserId", redUserId);
      map.put("redUserName", redUserName);
      map.put("redFlag", redFlag);
      map.put("redNotificationNo", redNotificationNo);
      map.put("status", status);
      map.put("matchedStatus", matchedStatus);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("printContentFlag", printContentFlag);
      map.put("ofdPath", ofdPath);
      map.put("pdfPath", pdfPath);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("makeOutUnitName", makeOutUnitName);
      map.put("handleStatus", handleStatus);
      map.put("handleRemark", handleRemark);
      map.put("outCheckStatus", outCheckStatus);
      map.put("outLockConfig", outLockConfig);
      map.put("identifyStatus", identifyStatus);
      map.put("printStatus", printStatus);
      map.put("retreatStatus", retreatStatus);
      map.put("paymentStatus", paymentStatus);
      map.put("terminalType", terminalType);
      map.put("deposeUserName", deposeUserName);
      map.put("deposeTime", BocpGenUtils.toTimestamp(deposeTime));
      map.put("deposeUserId", deposeUserId);
      map.put("sysOrgId", sysOrgId);
      map.put("invoiceUrl", invoiceUrl);
      map.put("mergeType", mergeType);
      map.put("customerNo", customerNo);
      map.put("lockFlag", lockFlag);
      map.put("addressee", addressee);
      map.put("addresseeTel", addresseeTel);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("direction", direction);
      map.put("logisticRemark", logisticRemark);
      map.put("addresseeComp", addresseeComp);
      map.put("addresseePost", addresseePost);
      map.put("businessLgtStatus", businessLgtStatus);
      map.put("procInstId", procInstId);
      map.put("auditType", auditType);
      map.put("diskNo", diskNo);
      map.put("systemOrigType", systemOrigType);
      map.put("electronicDataSyncTime", electronicDataSyncTime);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("purchaserBankInfo", purchaserBankInfo);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("makingReason", makingReason);
      map.put("makeType", makeType);
      map.put("receiveUserTel", receiveUserTel);
      map.put("invoiceKind", invoiceKind);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("xmlUrl", xmlUrl);
      map.put("channel", channel);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("source", source);
      map.put("invoiceId", invoiceId);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("purchaserTenantCode", purchaserTenantCode);

      return map;
  }

  public static Invoice fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Invoice entity = new Invoice();

    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserEPayId")) {
      Object obj = map.get("purchaserEPayId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserEPayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceFrom")) {
      Object obj = map.get("invoiceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abandonFlag")) {
      Object obj = map.get("abandonFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbandonFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedTime(null);
      }
    }
    if(map.containsKey("redUserId")) {
      Object obj = map.get("redUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchedStatus")) {
      Object obj = map.get("matchedStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchedStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchedStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMatchedStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ofdPath")) {
      Object obj = map.get("ofdPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeOutUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outCheckStatus")) {
      Object obj = map.get("outCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outLockConfig")) {
      Object obj = map.get("outLockConfig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutLockConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identifyStatus")) {
      Object obj = map.get("identifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdentifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalType")) {
      Object obj = map.get("terminalType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerminalType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deposeUserName")) {
      Object obj = map.get("deposeUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeposeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeposeTime(null);
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessLgtStatus")) {
      Object obj = map.get("businessLgtStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("procInstId")) {
      Object obj = map.get("procInstId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcInstId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditType")) {
      Object obj = map.get("auditType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAuditType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("diskNo")) {
      Object obj = map.get("diskNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiskNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("electronicDataSyncTime")) {
      Object obj = map.get("electronicDataSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantCode")) {
      Object obj = map.get("purchaserTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTenantCode((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserEPayId")) {
      Object obj = map.get("purchaserEPayId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserEPayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceFrom")) {
      Object obj = map.get("invoiceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVeriStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abandonFlag")) {
      Object obj = map.get("abandonFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbandonFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRedTime(null);
      }
    }
    if(map.containsKey("redUserId")) {
      Object obj = map.get("redUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchedStatus")) {
      Object obj = map.get("matchedStatus");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMatchedStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchedStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMatchedStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ofdPath")) {
      Object obj = map.get("ofdPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakeOutUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outCheckStatus")) {
      Object obj = map.get("outCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOutCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outLockConfig")) {
      Object obj = map.get("outLockConfig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOutLockConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identifyStatus")) {
      Object obj = map.get("identifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIdentifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrintStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalType")) {
      Object obj = map.get("terminalType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTerminalType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deposeUserName")) {
      Object obj = map.get("deposeUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeposeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeposeTime(null);
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeposeUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessLgtStatus")) {
      Object obj = map.get("businessLgtStatus");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("procInstId")) {
      Object obj = map.get("procInstId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcInstId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditType")) {
      Object obj = map.get("auditType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAuditType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("diskNo")) {
      Object obj = map.get("diskNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiskNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("electronicDataSyncTime")) {
      Object obj = map.get("electronicDataSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantCode")) {
      Object obj = map.get("purchaserTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTenantCode((String)obj);
        }
      } else{
      }
    }
  }
}
