package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_medical_service
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMedicalService implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 医保范围内费用
   */
  private String ybfwnfy;
  /**
   * 个人自付金额
   */
  private String grzfje;
  /**
   * 公务员补助基金支出
   */
  private String gwybzjjzc;
  /**
   * 企业补充医疗基金支出
   */
  private String qybcyljjzc;
  /**
   * 基本医疗统筹支付金额
   */
  private String jbyltczfje;
  /**
   * 现金支付
   */
  private String xjzfje;
  /**
   * 医疗人员补助基金支出
   */
  private String ylrybzjjzc;
  /**
   * 其他补助基金支出
   */
  private String qtbzjjzc;
  /**
   * 大病医疗统筹支付金额
   */
  private String dbyltczfje;
  /**
   * 医保个人账户支付
   */
  private String ybgrzhzf;
  /**
   * 退干补助基金支出
   */
  private String tgbzjjzc;
  /**
   * 民政救助金额
   */
  private String mzjzje;
  /**
   * 医保卡号
   */
  private String ybkh;
  /**
   * 医保账户余额
   */
  private String ybzhye;
  /**
   * 退休补助基金支出
   */
  private String txbzjjzc;
  /**
   * 民政救济金额
   */
  private String mzjjje;
  /**
   * 来源ID
   */
  private String sourceId;
  /**
   * 来源系统
   */
  private String source;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 invoice
   */
  private Long invoiceOneToManyMedicalServiceId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ybfwnfy", ybfwnfy);
      map.put("grzfje", grzfje);
      map.put("gwybzjjzc", gwybzjjzc);
      map.put("qybcyljjzc", qybcyljjzc);
      map.put("jbyltczfje", jbyltczfje);
      map.put("xjzfje", xjzfje);
      map.put("ylrybzjjzc", ylrybzjjzc);
      map.put("qtbzjjzc", qtbzjjzc);
      map.put("dbyltczfje", dbyltczfje);
      map.put("ybgrzhzf", ybgrzhzf);
      map.put("tgbzjjzc", tgbzjjzc);
      map.put("mzjzje", mzjzje);
      map.put("ybkh", ybkh);
      map.put("ybzhye", ybzhye);
      map.put("txbzjjzc", txbzjjzc);
      map.put("mzjjje", mzjjje);
      map.put("sourceId", sourceId);
      map.put("source", source);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("invoiceOneToManyMedicalService.id", invoiceOneToManyMedicalServiceId);
      return map;
  }

  public static InvoiceMedicalService fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMedicalService entity = new InvoiceMedicalService();

    if(map.containsKey("ybfwnfy")) {
      Object obj = map.get("ybfwnfy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbfwnfy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grzfje")) {
      Object obj = map.get("grzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gwybzjjzc")) {
      Object obj = map.get("gwybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGwybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qybcyljjzc")) {
      Object obj = map.get("qybcyljjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQybcyljjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jbyltczfje")) {
      Object obj = map.get("jbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xjzfje")) {
      Object obj = map.get("xjzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXjzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ylrybzjjzc")) {
      Object obj = map.get("ylrybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYlrybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qtbzjjzc")) {
      Object obj = map.get("qtbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQtbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbyltczfje")) {
      Object obj = map.get("dbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybgrzhzf")) {
      Object obj = map.get("ybgrzhzf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbgrzhzf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tgbzjjzc")) {
      Object obj = map.get("tgbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTgbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjzje")) {
      Object obj = map.get("mzjzje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMzjzje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybkh")) {
      Object obj = map.get("ybkh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbkh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybzhye")) {
      Object obj = map.get("ybzhye");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbzhye((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("txbzjjzc")) {
      Object obj = map.get("txbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTxbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjjje")) {
      Object obj = map.get("mzjjje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMzjjje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceId")) {
      Object obj = map.get("sourceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceOneToManyMedicalService.id")) {
       Object obj = map.get("invoiceOneToManyMedicalService.id");
       if(obj instanceof Long) {
         entity.setInvoiceOneToManyMedicalServiceId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setInvoiceOneToManyMedicalServiceId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ybfwnfy")) {
      Object obj = map.get("ybfwnfy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYbfwnfy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grzfje")) {
      Object obj = map.get("grzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGrzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gwybzjjzc")) {
      Object obj = map.get("gwybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGwybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qybcyljjzc")) {
      Object obj = map.get("qybcyljjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQybcyljjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jbyltczfje")) {
      Object obj = map.get("jbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xjzfje")) {
      Object obj = map.get("xjzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXjzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ylrybzjjzc")) {
      Object obj = map.get("ylrybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYlrybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qtbzjjzc")) {
      Object obj = map.get("qtbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQtbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbyltczfje")) {
      Object obj = map.get("dbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybgrzhzf")) {
      Object obj = map.get("ybgrzhzf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYbgrzhzf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tgbzjjzc")) {
      Object obj = map.get("tgbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTgbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjzje")) {
      Object obj = map.get("mzjzje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMzjzje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybkh")) {
      Object obj = map.get("ybkh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYbkh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybzhye")) {
      Object obj = map.get("ybzhye");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYbzhye((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("txbzjjzc")) {
      Object obj = map.get("txbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTxbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjjje")) {
      Object obj = map.get("mzjjje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMzjjje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceId")) {
      Object obj = map.get("sourceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSourceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("invoiceOneToManyMedicalService.id")) {
    Object obj = map.get("invoiceOneToManyMedicalService.id");
    if(obj instanceof Long) {
        this.setInvoiceOneToManyMedicalServiceId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setInvoiceOneToManyMedicalServiceId(Long.parseLong((String)obj));
    }
  }
  }
}
