package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-06-12
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1664465980207181826L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1664465981016682497L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1664465981717131265L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1664465982656655361L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Invoice {
        static Long id() {
            return 1664472562689159170L;
        }
        static String code() {
            return "invoice";
        }
        TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "batchNo");
        TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "outBatchNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "sellerGroupId");
        TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "sellerTenantId");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "sellerId");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "sellerCode");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "purchaserGroupId");
        TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "purchaserTenantId");
        TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "purchaserId");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "purchaserEPayId");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machineCode");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "checkCode");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "electronicSignature");
        TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceFrom");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "systemOrig");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "businessBillType");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "originPaperDrawDate");
        TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "originInvoiceType");
        TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "veriStatus");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipherText");
        TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "cipherTextTwoCode");
        TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "virtualFlag");
        TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "abandonFlag");
        TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "redTime");
        TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "redUserId");
        TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "redUserName");
        TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "redFlag");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<Long> STATUS = new TypedField<>(Long.class, "status");
        TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "matchedStatus");
        TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "saleListFileFlag");
        TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "printContentFlag");
        TypedField<String> OFD_PATH = new TypedField<>(String.class, "ofdPath");
        TypedField<String> PDF_PATH = new TypedField<>(String.class, "pdfPath");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receiveUserEmail");
        TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "makeOutUnitName");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "handleRemark");
        TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "outCheckStatus");
        TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "outLockConfig");
        TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "identifyStatus");
        TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "printStatus");
        TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "retreatStatus");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "terminalType");
        TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "deposeUserName");
        TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "deposeTime");
        TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "deposeUserId");
        TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "sysOrgId");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "mergeType");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "lockFlag");
        TypedField<String> ADDRESSEE = new TypedField<>(String.class, "addressee");
        TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "addresseeTel");
        TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "addresseeProvince");
        TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "addresseeCity");
        TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "addresseeCounty");
        TypedField<String> DIRECTION = new TypedField<>(String.class, "direction");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logisticRemark");
        TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "addresseeComp");
        TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "addresseePost");
        TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "businessLgtStatus");
        TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "procInstId");
        TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "auditType");
        TypedField<String> DISK_NO = new TypedField<>(String.class, "diskNo");
        TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "systemOrigType");
        TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "electronicDataSyncTime");
        TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "sellerBankInfo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "purchaserBankInfo");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaserAddrTel");
        TypedField<String> MAKING_REASON = new TypedField<>(String.class, "makingReason");
        TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "makeType");
        TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "receiveUserTel");
        TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceKind");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "taxInvoiceSource");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xmlUrl");
        TypedField<String> CHANNEL = new TypedField<>(String.class, "channel");
        TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "allElectricInvoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "specialInvoiceFlag");
        TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "sellerTenantCode");
        TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "purchaserTenantCode");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceItem {
        static Long id() {
            return 1664472562731102210L;
        }
        static String code() {
            return "invoiceItem";
        }
        TypedField<Long> PRE_INVOICE_ID = new TypedField<>(Long.class, "preInvoiceId");
        TypedField<Long> SALESBILL_ID = new TypedField<>(Long.class, "salesbillId");
        TypedField<Long> SALESBILL_ITEM_ID = new TypedField<>(Long.class, "salesbillItemId");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<Long> PRE_INVOICE_ITEM_ID = new TypedField<>(Long.class, "preInvoiceItemId");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> SALES_LIST_NO = new TypedField<>(String.class, "salesListNo");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargoCode");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargoName");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountWithoutTax");
        TypedField<BigDecimal> DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "discountTax");
        TypedField<BigDecimal> DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountWithTax");
        TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "discountRate");
        TypedField<String> TAX_ITEM = new TypedField<>(String.class, "taxItem");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goodsNoVer");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discountFlag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "itemShortName");
        TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "sellerGroupId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceId");
        TypedField<String> INVOICE_ITEM_ID = new TypedField<>(String.class, "invoiceItemId");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "specialInvoiceFlag");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_ITEM_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_ITEM {
                static String code () {
                    return "invoiceOneToManyItem" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyItem.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyItem.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyItem.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyItem.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyItem.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyItem.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyItem.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyItem.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyItem.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyItem.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyItem.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyItem.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyItem.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyItem.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyItem.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyItem.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyItem.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyItem.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyItem.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyItem.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyItem.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyItem.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyItem.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyItem.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyItem.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyItem.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyItem.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyItem.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyItem.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyItem.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyItem.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyItem.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyItem.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyItem.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyItem.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyItem.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyItem.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyItem.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyItem.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyItem.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyItem.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyItem.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyItem.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyItem.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyItem.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyItem.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyItem.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyItem.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyItem.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyItem.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyItem.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyItem.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyItem.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyItem.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyItem.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyItem.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyItem.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyItem.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyItem.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyItem.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyItem.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyItem.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyItem.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyItem.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyItem.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyItem.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyItem.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyItem.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceFreightage {
        static Long id() {
            return 1664472562752073771L;
        }
        static String code() {
            return "invoiceFreightage";
        }
        TypedField<String> TOOL_TYPE = new TypedField<>(String.class, "toolType");
        TypedField<String> TOOL_BRAND = new TypedField<>(String.class, "toolBrand");
        TypedField<String> NAME_OF_GOODS = new TypedField<>(String.class, "nameOfGoods");
        TypedField<String> PID = new TypedField<>(String.class, "pid");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenantCode");
        TypedField<String> PLACE_OF_SHIPMENT = new TypedField<>(String.class, "placeOfShipment");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ITEM_ID = new TypedField<>(String.class, "sourceItemId");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_FREIGHTAGE_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_FREIGHTAGE {
                static String code () {
                    return "invoiceOneToManyFreightage" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyFreightage.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyFreightage.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyFreightage.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyFreightage.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyFreightage.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyFreightage.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyFreightage.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyFreightage.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyFreightage.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyFreightage.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyFreightage.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyFreightage.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyFreightage.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyFreightage.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyFreightage.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyFreightage.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyFreightage.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyFreightage.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyFreightage.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyFreightage.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyFreightage.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyFreightage.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyFreightage.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyFreightage.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyFreightage.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyFreightage.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyFreightage.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyFreightage.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyFreightage.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyFreightage.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyFreightage.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyFreightage.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyFreightage.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyFreightage.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyFreightage.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyFreightage.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyFreightage.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyFreightage.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyFreightage.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyFreightage.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyFreightage.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyFreightage.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyFreightage.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyFreightage.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyFreightage.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyFreightage.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyFreightage.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyFreightage.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyFreightage.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyFreightage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyFreightage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyFreightage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyFreightage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyFreightage.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyFreightage.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyFreightage.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyFreightage.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyFreightage.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceConstructionServices {
        static Long id() {
            return 1664472562756268043L;
        }
        static String code() {
            return "invoiceConstructionServices";
        }
        TypedField<String> PLACE_OF_OCCURRENCE = new TypedField<>(String.class, "placeOfOccurrence");
        TypedField<String> ENTRY_NAME = new TypedField<>(String.class, "entryName");
        TypedField<String> LAND_VAT_ITEM_NO = new TypedField<>(String.class, "landVatItemNo");
        TypedField<String> PID = new TypedField<>(String.class, "pid");
        TypedField<String> PLACE = new TypedField<>(String.class, "place");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ITEM_ID = new TypedField<>(String.class, "sourceItemId");
        TypedField<String> CROSS_CITY_SIGN = new TypedField<>(String.class, "crossCitySign");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_CONSTRUCTION_SERVICES_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_CONSTRUCTION_SERVICES {
                static String code () {
                    return "invoiceOneToManyConstructionServices" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyConstructionServices.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyConstructionServices.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyConstructionServices.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyConstructionServices.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyConstructionServices.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyConstructionServices.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyConstructionServices.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyConstructionServices.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyConstructionServices.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyConstructionServices.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceRealEstateSales {
        static Long id() {
            return 1664472562756268065L;
        }
        static String code() {
            return "invoiceRealEstateSales";
        }
        TypedField<String> REAL_ESTATE_ADDRESS = new TypedField<>(String.class, "realEstateAddress");
        TypedField<String> REAL_ESTATE_NO = new TypedField<>(String.class, "realEstateNo");
        TypedField<String> REAL_ESTATE_CODE = new TypedField<>(String.class, "realEstateCode");
        TypedField<String> LAND_VAT_ITEM_NO = new TypedField<>(String.class, "landVatItemNo");
        TypedField<String> TAXABLE_PRICE = new TypedField<>(String.class, "taxablePrice");
        TypedField<String> TRANSACTION_PRICE = new TypedField<>(String.class, "transactionPrice");
        TypedField<String> AREA_UNIT = new TypedField<>(String.class, "areaUnit");
        TypedField<String> PID = new TypedField<>(String.class, "pid");
        TypedField<String> REAL_ESTATE_PLACE = new TypedField<>(String.class, "realEstatePlace");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ITEM_ID = new TypedField<>(String.class, "sourceItemId");
        TypedField<String> CROSS_CITY_SIGN = new TypedField<>(String.class, "crossCitySign");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_REAL_ESTATE_SALES_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_REAL_ESTATE_SALES {
                static String code () {
                    return "invoiceOneToManyRealEstateSales" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealEstateSales.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealEstateSales.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealEstateSales.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealEstateSales.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealEstateSales.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealEstateSales.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealEstateSales.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealEstateSales.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealEstateSales.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealEstateSales.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceRealLeasehold {
        static Long id() {
            return 1664472562756268091L;
        }
        static String code() {
            return "invoiceRealLeasehold";
        }
        TypedField<String> REAL_ESTATE_NO = new TypedField<>(String.class, "realEstateNo");
        TypedField<String> REAL_ESTATE_ADDRESS = new TypedField<>(String.class, "realEstateAddress");
        TypedField<String> LEASE_TERM_START = new TypedField<>(String.class, "leaseTermStart");
        TypedField<String> LEASE_TERM_END = new TypedField<>(String.class, "leaseTermEnd");
        TypedField<String> AREA_UNIT = new TypedField<>(String.class, "areaUnit");
        TypedField<String> PID = new TypedField<>(String.class, "pid");
        TypedField<String> REAL_ESTATE_PLACE = new TypedField<>(String.class, "realEstatePlace");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ITEM_ID = new TypedField<>(String.class, "sourceItemId");
        TypedField<String> LEASE_TERM = new TypedField<>(String.class, "leaseTerm");
        TypedField<String> CROSS_CITY_SIGN = new TypedField<>(String.class, "crossCitySign");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_REAL_LEASEHOLD_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_REAL_LEASEHOLD {
                static String code () {
                    return "invoiceOneToManyRealLeasehold" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealLeasehold.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealLeasehold.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealLeasehold.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyRealLeasehold.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealLeasehold.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealLeasehold.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealLeasehold.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyRealLeasehold.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyRealLeasehold.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyRealLeasehold.purchaserTenantCode");
            }
        }
    }
    public interface InvoicePassengerTransportation {
        static Long id() {
            return 1668137610051162113L;
        }
        static String code() {
            return "invoicePassengerTransportation";
        }
        TypedField<String> TRAVELERS = new TypedField<>(String.class, "travelers");
        TypedField<String> VALID_ID_NO = new TypedField<>(String.class, "validIdNo");
        TypedField<String> TRAVEL_DATE = new TypedField<>(String.class, "travelDate");
        TypedField<String> PLACE_OF_DEPARTURE = new TypedField<>(String.class, "placeOfDeparture");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> GRADE = new TypedField<>(String.class, "grade");
        TypedField<String> TYPE_OF_VEHICLE = new TypedField<>(String.class, "typeOfVehicle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_PASSENGER_TRANSPORTATION_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_PASSENGER_TRANSPORTATION {
                static String code () {
                    return "invoiceOneToManyPassengerTransportation" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyPassengerTransportation.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyPassengerTransportation.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyPassengerTransportation.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyPassengerTransportation.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyPassengerTransportation.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyPassengerTransportation.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyPassengerTransportation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyPassengerTransportation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyPassengerTransportation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyPassengerTransportation.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceTractorsAndCombines {
        static Long id() {
            return 1668137892223451137L;
        }
        static String code() {
            return "invoiceTractorsAndCombines";
        }
        TypedField<String> ENGINE_NUMBER = new TypedField<>(String.class, "engineNumber");
        TypedField<String> CHASSIS_NO = new TypedField<>(String.class, "chassisNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_TRACTORS_AND_COMBINES_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_TRACTORS_AND_COMBINES {
                static String code () {
                    return "invoiceOneToManyTractorsAndCombines" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyTractorsAndCombines.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyTractorsAndCombines.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyTractorsAndCombines.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyTractorsAndCombines.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyTractorsAndCombines.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyTractorsAndCombines.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyTractorsAndCombines.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyTractorsAndCombines.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyTractorsAndCombines.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyTractorsAndCombines.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceVehicleAndVesselTax {
        static Long id() {
            return 1668138346524299266L;
        }
        static String code() {
            return "invoiceVehicleAndVesselTax";
        }
        TypedField<String> POLICY_NO = new TypedField<>(String.class, "policyNo");
        TypedField<String> CAR_NUMBER = new TypedField<>(String.class, "carNumber");
        TypedField<String> TAX_PERIOD = new TypedField<>(String.class, "taxPeriod");
        TypedField<String> FRAME_NO = new TypedField<>(String.class, "frameNo");
        TypedField<String> VEHICLE_AND_VESSEL_TAX = new TypedField<>(String.class, "vehicleAndVesselTax");
        TypedField<String> LATE_FEE = new TypedField<>(String.class, "lateFee");
        TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_VEHICLE_AND_VESSEL_TAX_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_VEHICLE_AND_VESSEL_TAX {
                static String code () {
                    return "invoiceOneToManyVehicleAndVesselTax" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyVehicleAndVesselTax.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyVehicleAndVesselTax.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyVehicleAndVesselTax.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyVehicleAndVesselTax.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyVehicleAndVesselTax.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyVehicleAndVesselTax.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyVehicleAndVesselTax.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyVehicleAndVesselTax.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyVehicleAndVesselTax.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyVehicleAndVesselTax.purchaserTenantCode");
            }
        }
    }
    public interface InvoiceMedicalService {
        static Long id() {
            return 1668140186507739137L;
        }
        static String code() {
            return "invoiceMedicalService";
        }
        TypedField<String> YBFWNFY = new TypedField<>(String.class, "ybfwnfy");
        TypedField<String> GRZFJE = new TypedField<>(String.class, "grzfje");
        TypedField<String> GWYBZJJZC = new TypedField<>(String.class, "gwybzjjzc");
        TypedField<String> QYBCYLJJZC = new TypedField<>(String.class, "qybcyljjzc");
        TypedField<String> JBYLTCZFJE = new TypedField<>(String.class, "jbyltczfje");
        TypedField<String> XJZFJE = new TypedField<>(String.class, "xjzfje");
        TypedField<String> YLRYBZJJZC = new TypedField<>(String.class, "ylrybzjjzc");
        TypedField<String> QTBZJJZC = new TypedField<>(String.class, "qtbzjjzc");
        TypedField<String> DBYLTCZFJE = new TypedField<>(String.class, "dbyltczfje");
        TypedField<String> YBGRZHZF = new TypedField<>(String.class, "ybgrzhzf");
        TypedField<String> TGBZJJZC = new TypedField<>(String.class, "tgbzjjzc");
        TypedField<String> MZJZJE = new TypedField<>(String.class, "mzjzje");
        TypedField<String> YBKH = new TypedField<>(String.class, "ybkh");
        TypedField<String> YBZHYE = new TypedField<>(String.class, "ybzhye");
        TypedField<String> TXBZJJZC = new TypedField<>(String.class, "txbzjjzc");
        TypedField<String> MZJJJE = new TypedField<>(String.class, "mzjjje");
        TypedField<String> SOURCE_ID = new TypedField<>(String.class, "sourceId");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_ONE_TO_MANY_MEDICAL_SERVICE_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ONE_TO_MANY_MEDICAL_SERVICE {
                static String code () {
                    return "invoiceOneToManyMedicalService" ;
                }
                TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.batchNo");
                TypedField<Long> OUT_BATCH_NO = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.outBatchNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceNo");
                TypedField<Long> SELLER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.sellerGroupId");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.sellerTenantId");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerNo");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.sellerId");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerTaxNo");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerAddress");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerBankAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserName");
                TypedField<Long> PURCHASER_GROUP_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.purchaserGroupId");
                TypedField<Long> PURCHASER_TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.purchaserTenantId");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.purchaserId");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserNo");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserTel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserAddress");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserBankAccount");
                TypedField<String> PURCHASER_E_PAY_ID = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserEPayId");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceColor");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceType");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.machineCode");
                TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "invoiceOneToManyMedicalService.paperDrawDate");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.checkCode");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoicerName");
                TypedField<String> REMARK = new TypedField<>(String.class, "invoiceOneToManyMedicalService.remark");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.electronicSignature");
                TypedField<String> INVOICE_FROM = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceFrom");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.systemOrig");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.billType");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.businessBillType");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyMedicalService.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.taxRate");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceOneToManyMedicalService.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOneToManyMedicalService.taxAmount");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.originInvoiceCode");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.originPaperDrawDate");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.originInvoiceType");
                TypedField<Long> VERI_STATUS = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.veriStatus");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceOneToManyMedicalService.cipherText");
                TypedField<String> CIPHER_TEXT_TWO_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.cipherTextTwoCode");
                TypedField<String> VIRTUAL_FLAG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.virtualFlag");
                TypedField<String> ABANDON_FLAG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.abandonFlag");
                TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyMedicalService.redTime");
                TypedField<Long> RED_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.redUserId");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.redUserName");
                TypedField<Long> RED_FLAG = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.redFlag");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.redNotificationNo");
                TypedField<Long> STATUS = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.status");
                TypedField<Long> MATCHED_STATUS = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.matchedStatus");
                TypedField<Long> SALE_LIST_FILE_FLAG = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.saleListFileFlag");
                TypedField<Long> PRINT_CONTENT_FLAG = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.printContentFlag");
                TypedField<String> OFD_PATH = new TypedField<>(String.class, "invoiceOneToManyMedicalService.ofdPath");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "invoiceOneToManyMedicalService.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.receiveUserEmail");
                TypedField<String> MAKE_OUT_UNIT_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.makeOutUnitName");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.handleStatus");
                TypedField<String> HANDLE_REMARK = new TypedField<>(String.class, "invoiceOneToManyMedicalService.handleRemark");
                TypedField<String> OUT_CHECK_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.outCheckStatus");
                TypedField<String> OUT_LOCK_CONFIG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.outLockConfig");
                TypedField<String> IDENTIFY_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.identifyStatus");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.printStatus");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.retreatStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceOneToManyMedicalService.paymentStatus");
                TypedField<Long> TERMINAL_TYPE = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.terminalType");
                TypedField<String> DEPOSE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.deposeUserName");
                TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyMedicalService.deposeTime");
                TypedField<Long> DEPOSE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.deposeUserId");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.sysOrgId");
                TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceUrl");
                TypedField<Long> MERGE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.mergeType");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.customerNo");
                TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.lockFlag");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseeTel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseeProvince");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseeCity");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseeCounty");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "invoiceOneToManyMedicalService.direction");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "invoiceOneToManyMedicalService.logisticRemark");
                TypedField<String> ADDRESSEE_COMP = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseeComp");
                TypedField<String> ADDRESSEE_POST = new TypedField<>(String.class, "invoiceOneToManyMedicalService.addresseePost");
                TypedField<Long> BUSINESS_LGT_STATUS = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.businessLgtStatus");
                TypedField<String> PROC_INST_ID = new TypedField<>(String.class, "invoiceOneToManyMedicalService.procInstId");
                TypedField<Long> AUDIT_TYPE = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.auditType");
                TypedField<String> DISK_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.diskNo");
                TypedField<Long> SYSTEM_ORIG_TYPE = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.systemOrigType");
                TypedField<Long> ELECTRONIC_DATA_SYNC_TIME = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.electronicDataSyncTime");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerBankInfo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerAddrTel");
                TypedField<String> PURCHASER_BANK_INFO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserBankInfo");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserAddrTel");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "invoiceOneToManyMedicalService.makingReason");
                TypedField<Long> MAKE_TYPE = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.makeType");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.receiveUserTel");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceKind");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.taxInvoiceSource");
                TypedField<String> XML_URL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.xmlUrl");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "invoiceOneToManyMedicalService.channel");
                TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "invoiceOneToManyMedicalService.allElectricInvoiceNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyMedicalService.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOneToManyMedicalService.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOneToManyMedicalService.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOneToManyMedicalService.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.delete_flag");
                TypedField<String> SOURCE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.source");
                TypedField<String> INVOICE_ID = new TypedField<>(String.class, "invoiceOneToManyMedicalService.invoiceId");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceOneToManyMedicalService.specialInvoiceFlag");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.sellerTenantCode");
                TypedField<String> PURCHASER_TENANT_CODE = new TypedField<>(String.class, "invoiceOneToManyMedicalService.purchaserTenantCode");
            }
        }
    }
}
