package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.validator;

import com.xforceplus.ultraman.app.phoenixkylieservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.phoenixkylieservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(TransportationType.class)) {
            isValid = null != TransportationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransportationType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = null != ReverseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = null != SpecialType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = null != InvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = null != AreaUnit.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = null != AreaUnit.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = null != SpecialInvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Source.class)) {
            isValid = null != Source.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Source.class.getSimpleName());
            }
        }
        if(clazz.equals(CrossCitySign.class)) {
            isValid = null != CrossCitySign.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CrossCitySign.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfVehicle.class)) {
            isValid = null != TypeOfVehicle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TypeOfVehicle.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
