package com.xforceplus.ultraman.app.phoenixkylieservice.metadata.validator;

import com.xforceplus.ultraman.app.phoenixkylieservice.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.phoenixkylieservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(TransportationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TransportationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TransportationType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReverseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AreaUnit.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AreaUnit.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialInvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Source.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Source.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Source.class.getSimpleName());
            }
        }
        if(clazz.equals(CrossCitySign.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CrossCitySign.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CrossCitySign.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfVehicle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TypeOfVehicle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TypeOfVehicle.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
