package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


/**
 * 统一管理全电省市区信息feign客户端
 *
 * @author ultraman
 * @date 2024-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RegionEnums;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "phoenix-kylin-service")
public interface RegionEnumsFeignApi {

  /**
   * 通过id查询统一管理全电省市区信息
   * @param  id
   * @return R
   */
  @GetMapping("/regionEnums/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增统一管理全电省市区信息
   * @param regionEnums 统一管理全电省市区信息
   * @return R
   */
  @PostMapping("/regionEnums/add")
  public R save(@RequestBody RegionEnums regionEnums);

  /**
   * 修改统一管理全电省市区信息
   * @param regionEnums 统一管理全电省市区信息
   * @return R
   */
  @PostMapping("/regionEnums/update")
  public R updateById(@RequestBody RegionEnums regionEnums);

  /**
   * 通过id删除统一管理全电省市区信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/regionEnums/del/{id}" )
  public R removeById(@PathVariable Long id);

}