package com.xforceplus.ultraman.app.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 账户类型
 * </p>
 *
 * @author ultraman
 * @since 2022-12-22
 */
public enum AccountType {

    AR("AR", "销方"),
    AP("AP", "购方");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountType fromCode(String code){
        switch(code) {
            case "AR":
                return AR;
            case "AP":
                return AP;
            default:
                return null;
        }
    }
}
