package com.xforceplus.ultraman.app.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 面积单位
 * </p>
 *
 * @author ultraman
 * @since 2022-12-22
 */
public enum AreaUnit {

    _01("01", "平方米"),
    _02("02", "亩"),
    _03("03", "㎡"),
    _04("04", "平方千米"),
    _05("05", "公顷"),
    _06("06", "h㎡"),
    _07("07", "k㎡");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AreaUnit(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AreaUnit fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            default:
                return null;
        }
    }
}
