package com.xforceplus.ultraman.app.phoenixkylinservice.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 4.0
 * </p>
 *
 * @author ultraman
 * @since 2022-12-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvSellerPreInvoice implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private Long batchNo;

  /**
   * 系统外批次号  默认batch_no的值
   */
  @TableField("outBatchNo")
  private Long outBatchNo;

  /**
   * 用户Id 下发数据需要  由属地直接传过来
   */
  @TableField("customerNo")
  private String customerNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 系统来源  下发数据需要  由属地直接传过来
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 业务单id
   */
  @TableField("salesbillId")
  private Long salesbillId;

  /**
   * 购方集团id
   */
  @TableField("purchaserTenantId")
  private Long purchaserTenantId;

  /**
   * 购方租户ID
   */
  @TableField("purchaserGroupId")
  private Long purchaserGroupId;

  /**
   * 购方公司id
   */
  @TableField("purchaserId")
  private Long purchaserId;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方开户行
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 销方集团id
   */
  @TableField("sellerTenantId")
  private Long sellerTenantId;

  /**
   * 销方租户id
   */
  @TableField("sellerGroupId")
  private Long sellerGroupId;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方开户行
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 销方公司id
   */
  @TableField("sellerId")
  private Long sellerId;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 业务单据类型
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 单据类型
   */
  @TableField("salesbillType")
  private String salesbillType;

  /**
   * 开票日期
   */
  @TableField("paperDrawDate")
  private String paperDrawDate;

  /**
   * 机器编码
   */
  @TableField("machineCode")
  private String machineCode;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 价税合计
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 收款人
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 电子签章
   */
  @TableField("electronicSignature")
  private String electronicSignature;

  /**
   * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
   */
  private Long status;

  /**
   * 业务单修改标记 0-未修改过 0>-修改次数， 这个标记字段从业务单传递过来的
   */
  @TableField("modifyMark")
  private Long modifyMark;

  /**
   * 预制发票是否锁定;0=未锁;1=锁定;2=开票锁;3=作废锁(蓝票用)
   */
  @TableField("lockFlag")
  private Long lockFlag;

  /**
   * 红票专用 0-红字业务单生成 5-蓝票红冲生成
   */
  @TableField("redFlag")
  private Long redFlag;

  /**
   * 规则id
   */
  @TableField("ruleId")
  private Long ruleId;

  /**
   * 组织机构id
   */
  @TableField("sysOrgId")
  private Long sysOrgId;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 原蓝票发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 原蓝票的开票日期
   */
  @TableField("originPaperDrawDate")
  private String originPaperDrawDate;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 接收方邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 接收方电话
   */
  @TableField("receiveUserTel")
  private String receiveUserTel;

  /**
   * 发票签名 用于抽取匹配
   */
  @TableField("invoiceSignature")
  private String invoiceSignature;

  /**
   * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量) 
   */
  @TableField("displayPriceQuality")
  private Long displayPriceQuality;

  /**
   * 销货清单文件打印标志 (0-否, 1-是)
   */
  @TableField("saleListFileFlag")
  private Long saleListFileFlag;

  /**
   * 版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用) 
   */
  @TableField("templateVersion")
  private Long templateVersion;

  /**
   * 销货清单备注
   */
  @TableField("listGoodsName")
  private String listGoodsName;

  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   */
  @TableField("mergeType")
  private Long mergeType;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 物流 收件人
   */
  private String addressee;

  /**
   * 物流-收件人电话
   */
  @TableField("addresseeTel")
  private String addresseeTel;

  /**
   * 物流-收件人省份
   */
  @TableField("addresseeProvince")
  private String addresseeProvince;

  /**
   * 物流-收件人城市
   */
  @TableField("addresseeCity")
  private String addresseeCity;

  /**
   * 物流-收件人所在县区
   */
  @TableField("addresseeCounty")
  private String addresseeCounty;

  /**
   * 物流-收件人地址
   */
  private String direction;

  /**
   * 物流备注
   */
  @TableField("logisticRemark")
  private String logisticRemark;

  /**
   * 收件人所在单位
   */
  @TableField("addresseeComp")
  private String addresseeComp;

  /**
   * 收件人邮编
   */
  @TableField("addresseePost")
  private String addresseePost;

  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  @TableField("systemOrigType")
  private Long systemOrigType;

  /**
   * 1/0时 代成功与否状态,如果是一串编码代表错误码
   */
  @TableField("processFlag")
  private String processFlag;

  /**
   * 处理备注
   */
  @TableField("processRemark")
  private String processRemark;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   */
  @TableField("makingReason")
  private String makingReason;

  /**
   * 开票方式 0-否 1-是
   */
  @TableField("makeType")
  private Long makeType;

  /**
   * 发票票种 s-纸专; se-电专; c-纸普; ce-电普; v-机动车; vs-二手机动车; ju-卷票
   */
  @TableField("invoiceKind")
  private String invoiceKind;

  /**
   * 税控发票来源 qd-全电发票 sk-税控发票
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 渠道
   */
  private String channel;

  /**
   * 全电发票号码
   */
  @TableField("allElectricInvoiceNo")
  private String allElectricInvoiceNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 来源
   */
  private String source;

  /**
   * 预制发票ID
   */
  @TableField("preInvoiceId")
  private String preInvoiceId;

  /**
   * 特殊发票标记
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("batchNo", batchNo);
      map.put("outBatchNo", outBatchNo);
      map.put("customerNo", customerNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("systemOrig", systemOrig);
      map.put("salesbillNo", salesbillNo);
      map.put("salesbillId", salesbillId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserId", purchaserId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerId", sellerId);
      map.put("invoiceType", invoiceType);
      map.put("businessBillType", businessBillType);
      map.put("salesbillType", salesbillType);
      map.put("paperDrawDate", paperDrawDate);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("electronicSignature", electronicSignature);
      map.put("status", status);
      map.put("modifyMark", modifyMark);
      map.put("lockFlag", lockFlag);
      map.put("redFlag", redFlag);
      map.put("ruleId", ruleId);
      map.put("sysOrgId", sysOrgId);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originInvoiceType", originInvoiceType);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("redNotificationNo", redNotificationNo);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("receiveUserTel", receiveUserTel);
      map.put("invoiceSignature", invoiceSignature);
      map.put("displayPriceQuality", displayPriceQuality);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("templateVersion", templateVersion);
      map.put("listGoodsName", listGoodsName);
      map.put("mergeType", mergeType);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("addressee", addressee);
      map.put("addresseeTel", addresseeTel);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("direction", direction);
      map.put("logisticRemark", logisticRemark);
      map.put("addresseeComp", addresseeComp);
      map.put("addresseePost", addresseePost);
      map.put("systemOrigType", systemOrigType);
      map.put("processFlag", processFlag);
      map.put("processRemark", processRemark);
      map.put("discountRate", discountRate);
      map.put("makingReason", makingReason);
      map.put("makeType", makeType);
      map.put("invoiceKind", invoiceKind);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("channel", channel);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("source", source);
      map.put("preInvoiceId", preInvoiceId);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      return map;
  }

  public static InvSellerPreInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvSellerPreInvoice entity = new InvSellerPreInvoice();
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutBatchNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesbillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyMark((Long)obj);
        } else if(obj instanceof String) {
          entity.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ruleId")) {
      Object obj = map.get("ruleId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRuleId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRuleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRuleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignature")) {
      Object obj = map.get("invoiceSignature");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("displayPriceQuality")) {
      Object obj = map.get("displayPriceQuality");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDisplayPriceQuality((Long)obj);
        } else if(obj instanceof String) {
          entity.setDisplayPriceQuality(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDisplayPriceQuality(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("templateVersion")) {
      Object obj = map.get("templateVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTemplateVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setTemplateVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTemplateVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("listGoodsName")) {
      Object obj = map.get("listGoodsName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setListGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMergeType((Long)obj);
        } else if(obj instanceof String) {
          entity.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeType((Long)obj);
        } else if(obj instanceof String) {
          entity.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBatchNo((Long)obj);
        } else if(obj instanceof String) {
          this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOutBatchNo((Long)obj);
        } else if(obj instanceof String) {
          this.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesbillId((Long)obj);
        } else if(obj instanceof String) {
          this.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElectronicSignature((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModifyMark((Long)obj);
        } else if(obj instanceof String) {
          this.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLockFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ruleId")) {
      Object obj = map.get("ruleId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRuleId((Long)obj);
        } else if(obj instanceof String) {
          this.setRuleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRuleId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceSignature")) {
      Object obj = map.get("invoiceSignature");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceSignature((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("displayPriceQuality")) {
      Object obj = map.get("displayPriceQuality");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDisplayPriceQuality((Long)obj);
        } else if(obj instanceof String) {
          this.setDisplayPriceQuality(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDisplayPriceQuality(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("templateVersion")) {
      Object obj = map.get("templateVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTemplateVersion((Long)obj);
        } else if(obj instanceof String) {
          this.setTemplateVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTemplateVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("listGoodsName")) {
      Object obj = map.get("listGoodsName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setListGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMergeType((Long)obj);
        } else if(obj instanceof String) {
          this.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMergeType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCounty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeComp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseePost((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakingReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMakeType((Long)obj);
        } else if(obj instanceof String) {
          this.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMakeType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
  }
}
