package com.xforceplus.ultraman.app.phoenixkylinservice.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 4.0
 * </p>
 *
 * @author ultraman
 * @since 2022-12-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvSellerInvoice implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 预制发票序列号
   */
  @TableField("preInvoiceId")
  private Long preInvoiceId;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private Long batchNo;

  /**
   * 系统外批次号  默认batch_no的值
   */
  @TableField("outBatchNo")
  private Long outBatchNo;

  /**
   * 结算单序号
   */
  @TableField("salesbillId")
  private String salesbillId;

  /**
   * 结算单号（企业）
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 销方集团id
   */
  @TableField("sellerGroupId")
  private Long sellerGroupId;

  /**
   * 销方租户id
   */
  @TableField("sellerTenantId")
  private Long sellerTenantId;

  /**
   * 销方租户公司编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方组织ID
   */
  @TableField("sellerId")
  private Long sellerId;

  /**
   * 销方代码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方纳税人识别号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方集团id
   */
  @TableField("purchaserGroupId")
  private Long purchaserGroupId;

  /**
   * 购方租户id
   */
  @TableField("purchaserTenantId")
  private Long purchaserTenantId;

  /**
   * 购方组织ID
   */
  @TableField("purchaserId")
  private Long purchaserId;

  /**
   * 购方租户公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 购方纳税人识别号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 购方电子支付标识
   */
  @TableField("purchaserEPayId")
  private String purchaserEPayId;

  /**
   * 红蓝标识 1-蓝票 2-红票 3-红冲票
   */
  @TableField("invoiceColor")
  private String invoiceColor;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 机器编码
   */
  @TableField("machineCode")
  private String machineCode;

  /**
   * 开票日期
   */
  @TableField("paperDrawDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;

  /**
   * check_code
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 备注
   */
  private String remark;

  /**
   * 电子签名
   */
  @TableField("electronicSignature")
  private String electronicSignature;

  /**
   * 发票来源 0-直连开票 1-辅助抽取 2-手工回填
   */
  @TableField("invoiceOrigin")
  private String invoiceOrigin;

  /**
   * 发票来源方 0-4.0平台 1-协同平台
   */
  @TableField("invoiceFrom")
  private String invoiceFrom;

  /**
   * 系统来源 下发数据需要  由属地直接传过来
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 单据类型
   */
  @TableField("billType")
  private String billType;

  /**
   * 适用业务单据类型
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 原蓝票的开票日期
   */
  @TableField("originPaperDrawDate")
  private String originPaperDrawDate;

  /**
   * 原发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
   */
  @TableField("veriStatus")
  private Long veriStatus;

  /**
   * 密文
   */
  @TableField("cipherText")
  private String cipherText;

  /**
   * 二维密文
   */
  @TableField("cipherTextTwoCode")
  private String cipherTextTwoCode;

  /**
   * 虚拟标志
   */
  @TableField("virtualFlag")
  private String virtualFlag;

  /**
   * 作废标识 0-默认 1-批次内 2-批次外
   */
  @TableField("abandonFlag")
  private String abandonFlag;

  /**
   * 红冲时间
   */
  @TableField("redTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redTime;

  /**
   * 红冲人id
   */
  @TableField("redUserId")
  private Long redUserId;

  /**
   * 红冲人姓名
   */
  @TableField("redUserName")
  private String redUserName;

  /**
   * 0-正常, 1-待红冲, 2-待部分红冲, 3-已红冲, 4-已部分红冲, 5-红冲票
   */
  @TableField("redFlag")
  private Long redFlag;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 发票状态1-正常 0-作废 2-待处理
   */
  private Long status;

  /**
   * 阳光城-生成凭证后锁定、解锁标志  0-解锁  1-锁定
   */
  @TableField("matchedStatus")
  private Long matchedStatus;

  /**
   * 销货清单文件打印标志（0-否,1-是）默认0
   */
  @TableField("saleListFileFlag")
  private Long saleListFileFlag;

  /**
   * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
   */
  @TableField("printContentFlag")
  private Long printContentFlag;

  /**
   * ofd路径
   */
  @TableField("ofdPath")
  private String ofdPath;

  /**
   * pdf路径
   */
  @TableField("pdfPath")
  private String pdfPath;

  /**
   * 接收方邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 开票点名称
   */
  @TableField("makeOutUnitName")
  private String makeOutUnitName;

  /**
   * 处理状态 1-正常  2-处理中 3-业务系统红冲 4-业务系统作废 5-进项退回
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * 处理备注
   */
  @TableField("handleRemark")
  private String handleRemark;

  /**
   * 外部批次生成标志 1-不生成 0-生成
   */
  @TableField("outCheckStatus")
  private String outCheckStatus;

  /**
   * 系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
   */
  @TableField("outLockConfig")
  private String outLockConfig;

  /**
   * 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出
   */
  @TableField("identifyStatus")
  private String identifyStatus;

  /**
   * 打印状态1-已打印 0-未打印
   */
  @TableField("printStatus")
  private String printStatus;

  /**
   * 退票状态 0-未退(默认) 1-已退
   */
  @TableField("retreatStatus")
  private String retreatStatus;

  /**
   * 付款状态 0-未付款(默认) 1-部分付款 2-已付款
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 开票点代码
   */
  @TableField("makeOutUnitCode")
  private String makeOutUnitCode;

  /**
   * 设备唯一码
   */
  @TableField("deviceUn")
  private String deviceUn;

  /**
   * 终端唯一码
   */
  @TableField("terminalUn")
  private String terminalUn;

  /**
   * 终端类型 1-单盘 2-服务器 4-区块链
   */
  @TableField("terminalType")
  private Long terminalType;

  /**
   * 作废的人名字
   */
  @TableField("deposeUserName")
  private String deposeUserName;

  /**
   * 作废时间
   */
  @TableField("deposeTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deposeTime;

  /**
   * 作废操作账号
   */
  @TableField("deposeUserId")
  private Long deposeUserId;

  /**
   * 权限ID
   */
  @TableField("sysOrgId")
  private Long sysOrgId;

  /**
   * ext1
   */
  private String ext1;

  /**
   * ext2
   */
  private String ext2;

  /**
   * ext3
   */
  private String ext3;

  /**
   * ext4
   */
  private String ext4;

  /**
   * ext5
   */
  private String ext5;

  /**
   * ext6
   */
  private String ext6;

  /**
   * ext7
   */
  private String ext7;

  /**
   * ext8
   */
  private String ext8;

  /**
   * ext11
   */
  private String ext9;

  /**
   * ext10
   */
  private String ext10;

  /**
   * ext11
   */
  private String ext11;

  /**
   * ext12
   */
  private String ext12;

  /**
   * ext13
   */
  private String ext13;

  /**
   * ext14
   */
  private String ext14;

  /**
   * ext15
   */
  private String ext15;

  /**
   * ext16
   */
  private String ext16;

  /**
   * ext17
   */
  private String ext17;

  /**
   * ext18
   */
  private String ext18;

  /**
   * ext19
   */
  private String ext19;

  /**
   * ext20
   */
  private String ext20;

  /**
   * ext21
   */
  private String ext21;

  /**
   * ext22
   */
  private String ext22;

  /**
   * ext23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 发票影像的URL
   */
  @TableField("invoiceUrl")
  private String invoiceUrl;

  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   */
  @TableField("mergeType")
  private Long mergeType;

  /**
   * 用户ID下发数据需要,由属地直接传过来
   */
  @TableField("customerNo")
  private String customerNo;

  /**
   * 锁定状态 0-未锁定;1-页面锁定;2-作废锁;3-打印锁;4-红冲锁;
   */
  @TableField("lockFlag")
  private Long lockFlag;

  /**
   * 物流 收件人
   */
  private String addressee;

  /**
   * 物流-收件人电话
   */
  @TableField("addresseeTel")
  private String addresseeTel;

  /**
   * 物流-收件人省份
   */
  @TableField("addresseeProvince")
  private String addresseeProvince;

  /**
   * 物流-收件人城市
   */
  @TableField("addresseeCity")
  private String addresseeCity;

  /**
   * 物流-收件人所在县区
   */
  @TableField("addresseeCounty")
  private String addresseeCounty;

  /**
   * 物流-收件人地址
   */
  private String direction;

  /**
   * 物流备注
   */
  @TableField("logisticRemark")
  private String logisticRemark;

  /**
   * 收件人所在单位
   */
  @TableField("addresseeComp")
  private String addresseeComp;

  /**
   * 收件人邮编
   */
  @TableField("addresseePost")
  private String addresseePost;

  /**
   * 物流状态 1-待寄送 3-寄送中
   */
  @TableField("businessLgtStatus")
  private Long businessLgtStatus;

  /**
   * 审批流程id
   */
  @TableField("procInstId")
  private String procInstId;

  /**
   * 0:正常 1:红冲 2:作废
   */
  @TableField("auditType")
  private Long auditType;

  /**
   * 开票机号
   */
  @TableField("diskNo")
  private String diskNo;

  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  @TableField("systemOrigType")
  private Long systemOrigType;

  /**
   * 电子数据同步时间
   */
  @TableField("electronicDataSyncTime")
  private Long electronicDataSyncTime;

  /**
   * 销方银行信息
   */
  @TableField("sellerBankInfo")
  private String sellerBankInfo;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 购方银行信息
   */
  @TableField("purchaserBankInfo")
  private String purchaserBankInfo;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   */
  @TableField("makingReason")
  private String makingReason;

  /**
   * 开票方式 0-否 1-是
   */
  @TableField("makeType")
  private Long makeType;

  /**
   * 接收方电话
   */
  @TableField("receiveUserTel")
  private String receiveUserTel;

  /**
   * 发票票种 s-纸专; se-电专; c-纸普; ce-电普; v-机动车; vs-二手机动车; ju-卷票
   */
  @TableField("invoiceKind")
  private String invoiceKind;

  /**
   * 税控发票来源 qd-全电发票 sk-税控发票
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * xml地址
   */
  @TableField("xmlUrl")
  private String xmlUrl;

  /**
   * 渠道
   */
  private String channel;

  /**
   * 全电发票号码
   */
  @TableField("allElectricInvoiceNo")
  private String allElectricInvoiceNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 来源
   */
  private String source;

  /**
   * 发票ID
   */
  @TableField("invoiceId")
  private String invoiceId;

  /**
   * 特殊发票标记
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("preInvoiceId", preInvoiceId);
      map.put("batchNo", batchNo);
      map.put("outBatchNo", outBatchNo);
      map.put("salesbillId", salesbillId);
      map.put("salesbillNo", salesbillNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerNo", sellerNo);
      map.put("sellerId", sellerId);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserName", purchaserName);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserId", purchaserId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserEPayId", purchaserEPayId);
      map.put("invoiceColor", invoiceColor);
      map.put("invoiceType", invoiceType);
      map.put("machineCode", machineCode);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("checkCode", checkCode);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("remark", remark);
      map.put("electronicSignature", electronicSignature);
      map.put("invoiceOrigin", invoiceOrigin);
      map.put("invoiceFrom", invoiceFrom);
      map.put("systemOrig", systemOrig);
      map.put("billType", billType);
      map.put("businessBillType", businessBillType);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("originInvoiceType", originInvoiceType);
      map.put("veriStatus", veriStatus);
      map.put("cipherText", cipherText);
      map.put("cipherTextTwoCode", cipherTextTwoCode);
      map.put("virtualFlag", virtualFlag);
      map.put("abandonFlag", abandonFlag);
      map.put("redTime", BocpGenUtils.toTimestamp(redTime));
      map.put("redUserId", redUserId);
      map.put("redUserName", redUserName);
      map.put("redFlag", redFlag);
      map.put("redNotificationNo", redNotificationNo);
      map.put("status", status);
      map.put("matchedStatus", matchedStatus);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("printContentFlag", printContentFlag);
      map.put("ofdPath", ofdPath);
      map.put("pdfPath", pdfPath);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("makeOutUnitName", makeOutUnitName);
      map.put("handleStatus", handleStatus);
      map.put("handleRemark", handleRemark);
      map.put("outCheckStatus", outCheckStatus);
      map.put("outLockConfig", outLockConfig);
      map.put("identifyStatus", identifyStatus);
      map.put("printStatus", printStatus);
      map.put("retreatStatus", retreatStatus);
      map.put("paymentStatus", paymentStatus);
      map.put("makeOutUnitCode", makeOutUnitCode);
      map.put("deviceUn", deviceUn);
      map.put("terminalUn", terminalUn);
      map.put("terminalType", terminalType);
      map.put("deposeUserName", deposeUserName);
      map.put("deposeTime", BocpGenUtils.toTimestamp(deposeTime));
      map.put("deposeUserId", deposeUserId);
      map.put("sysOrgId", sysOrgId);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("invoiceUrl", invoiceUrl);
      map.put("mergeType", mergeType);
      map.put("customerNo", customerNo);
      map.put("lockFlag", lockFlag);
      map.put("addressee", addressee);
      map.put("addresseeTel", addresseeTel);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("direction", direction);
      map.put("logisticRemark", logisticRemark);
      map.put("addresseeComp", addresseeComp);
      map.put("addresseePost", addresseePost);
      map.put("businessLgtStatus", businessLgtStatus);
      map.put("procInstId", procInstId);
      map.put("auditType", auditType);
      map.put("diskNo", diskNo);
      map.put("systemOrigType", systemOrigType);
      map.put("electronicDataSyncTime", electronicDataSyncTime);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("purchaserBankInfo", purchaserBankInfo);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("makingReason", makingReason);
      map.put("makeType", makeType);
      map.put("receiveUserTel", receiveUserTel);
      map.put("invoiceKind", invoiceKind);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("xmlUrl", xmlUrl);
      map.put("channel", channel);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("source", source);
      map.put("invoiceId", invoiceId);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      return map;
  }

  public static InvSellerInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvSellerInvoice entity = new InvSellerInvoice();
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPreInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPreInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPreInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutBatchNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserEPayId")) {
      Object obj = map.get("purchaserEPayId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserEPayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceFrom")) {
      Object obj = map.get("invoiceFrom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abandonFlag")) {
      Object obj = map.get("abandonFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbandonFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedTime(null);
      }
    }
    if(map.containsKey("redUserId")) {
      Object obj = map.get("redUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchedStatus")) {
      Object obj = map.get("matchedStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchedStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setMatchedStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchedStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ofdPath")) {
      Object obj = map.get("ofdPath");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOfdPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeOutUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outCheckStatus")) {
      Object obj = map.get("outCheckStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outLockConfig")) {
      Object obj = map.get("outLockConfig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutLockConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identifyStatus")) {
      Object obj = map.get("identifyStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIdentifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrintStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitCode")) {
      Object obj = map.get("makeOutUnitCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeOutUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceUn")) {
      Object obj = map.get("deviceUn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalUn")) {
      Object obj = map.get("terminalUn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTerminalUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalType")) {
      Object obj = map.get("terminalType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerminalType((Long)obj);
        } else if(obj instanceof String) {
          entity.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deposeUserName")) {
      Object obj = map.get("deposeUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeposeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeposeTime(null);
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMergeType((Long)obj);
        } else if(obj instanceof String) {
          entity.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessLgtStatus")) {
      Object obj = map.get("businessLgtStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("procInstId")) {
      Object obj = map.get("procInstId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcInstId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditType")) {
      Object obj = map.get("auditType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditType((Long)obj);
        } else if(obj instanceof String) {
          entity.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuditType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("diskNo")) {
      Object obj = map.get("diskNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiskNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("electronicDataSyncTime")) {
      Object obj = map.get("electronicDataSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String) {
          entity.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeType((Long)obj);
        } else if(obj instanceof String) {
          entity.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPreInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          this.setPreInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPreInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBatchNo((Long)obj);
        } else if(obj instanceof String) {
          this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOutBatchNo((Long)obj);
        } else if(obj instanceof String) {
          this.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserEPayId")) {
      Object obj = map.get("purchaserEPayId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserEPayId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElectronicSignature((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceFrom")) {
      Object obj = map.get("invoiceFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVeriStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherTextTwoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVirtualFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("abandonFlag")) {
      Object obj = map.get("abandonFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbandonFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRedTime(null);
      }
    }
    if(map.containsKey("redUserId")) {
      Object obj = map.get("redUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("matchedStatus")) {
      Object obj = map.get("matchedStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMatchedStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setMatchedStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchedStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ofdPath")) {
      Object obj = map.get("ofdPath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOfdPath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfPath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeOutUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outCheckStatus")) {
      Object obj = map.get("outCheckStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outLockConfig")) {
      Object obj = map.get("outLockConfig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutLockConfig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("identifyStatus")) {
      Object obj = map.get("identifyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdentifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printStatus")) {
      Object obj = map.get("printStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeOutUnitCode")) {
      Object obj = map.get("makeOutUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeOutUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deviceUn")) {
      Object obj = map.get("deviceUn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeviceUn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("terminalUn")) {
      Object obj = map.get("terminalUn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTerminalUn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("terminalType")) {
      Object obj = map.get("terminalType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTerminalType((Long)obj);
        } else if(obj instanceof String) {
          this.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("deposeUserName")) {
      Object obj = map.get("deposeUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeposeUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeposeTime(null);
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeposeUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceUrl")) {
      Object obj = map.get("invoiceUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMergeType((Long)obj);
        } else if(obj instanceof String) {
          this.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMergeType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLockFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCounty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeComp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseePost((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessLgtStatus")) {
      Object obj = map.get("businessLgtStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("procInstId")) {
      Object obj = map.get("procInstId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcInstId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditType")) {
      Object obj = map.get("auditType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditType((Long)obj);
        } else if(obj instanceof String) {
          this.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuditType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("diskNo")) {
      Object obj = map.get("diskNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiskNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("electronicDataSyncTime")) {
      Object obj = map.get("electronicDataSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String) {
          this.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakingReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMakeType((Long)obj);
        } else if(obj instanceof String) {
          this.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMakeType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXmlUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
  }
}
