package com.xforceplus.ultraman.app.phoenixkylinservice.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 4.0
 * </p>
 *
 * @author ultraman
 * @since 2022-12-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrdSalesbill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据主键ID
   */
  @TableField("salesbillId")
  private Long salesbillId;

  /**
   * 单据编号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 原单据编号
   */
  @TableField("originSalesbillNo")
  private String originSalesbillNo;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账户
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 销方集团id
   */
  @TableField("sellerGroupId")
  private Long sellerGroupId;

  /**
   * 销方公司id
   */
  @TableField("sellerId")
  private Long sellerId;

  /**
   * 购方公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账户
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 购方集团ID
   */
  @TableField("purchaserGroupId")
  private Long purchaserGroupId;

  /**
   * 购方公司id
   */
  @TableField("purchaserId")
  private Long purchaserId;

  /**
   * AP：购方  AR-销方
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 国税发票来源 qd - 全电发票 sk - 税控发票
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 系统来源
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 业务单据类型
   */
  @TableField("salesbillType")
  private String salesbillType;

  /**
   * 票据类型
   */
  @TableField("receiptType")
  private String receiptType;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 计价方式
   */
  @TableField("priceMethod")
  private Long priceMethod;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 业务单上传的原始金额，考虑容差比较使用，价格方式为0 位不含税税金额，否则为含税金额
   */
  @TableField("originAmount")
  private BigDecimal originAmount;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 已开含税金额
   */
  @TableField("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax;

  /**
   * 已开不含税金额
   */
  @TableField("alreadyMakeAmountWithoutTax")
  private BigDecimal alreadyMakeAmountWithoutTax;

  /**
   * 已开税额
   */
  @TableField("alreadyMakeAmountTaxAmount")
  private BigDecimal alreadyMakeAmountTaxAmount;

  /**
   * 作废发票不释放含税金额
   */
  @TableField("abandonFreezeAmountWithTax")
  private BigDecimal abandonFreezeAmountWithTax;

  /**
   * 作废发票不释放不含税金额
   */
  @TableField("abandonFreezeAmountWithoutTax")
  private BigDecimal abandonFreezeAmountWithoutTax;

  /**
   * 作废发票不释放税额
   */
  @TableField("abandonFreezeAmountTaxAmount")
  private BigDecimal abandonFreezeAmountTaxAmount;

  /**
   * 折扣含税总额
   */
  @TableField("discountWithTaxTotal")
  private BigDecimal discountWithTaxTotal;

  /**
   * 折扣不含税总额
   */
  @TableField("discountWithoutTaxTotal")
  private BigDecimal discountWithoutTaxTotal;

  /**
   * 折扣总额税额
   */
  @TableField("discountTaxAmountTotal")
  private BigDecimal discountTaxAmountTotal;

  /**
   * 价外含税折扣
   */
  @TableField("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax;

  /**
   * 价外不含税折扣
   */
  @TableField("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 价内含税折扣
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内不含税折扣
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价外预付卡含税金额
   */
  @TableField("outterPrepayAmountWithTax")
  private BigDecimal outterPrepayAmountWithTax;

  /**
   * 价外预付卡不含税金额
   */
  @TableField("outterPrepayAmountWithoutTax")
  private BigDecimal outterPrepayAmountWithoutTax;

  /**
   * 价内预付卡含税金额
   */
  @TableField("innerPrepayAmountWithTax")
  private BigDecimal innerPrepayAmountWithTax;

  /**
   * 价内预付卡不含税金额
   */
  @TableField("innerPrepayAmountWithoutTax")
  private BigDecimal innerPrepayAmountWithoutTax;

  /**
   * 协同标识 1 协同 0 不协同
   */
  @TableField("cooperateFlag")
  private Long cooperateFlag;

  /**
   * 上传方确认标识
   */
  @TableField("uploadConfirmFlag")
  private Long uploadConfirmFlag;

  /**
   * 接收方确认标识
   */
  @TableField("receiveConfirmFlag")
  private Long receiveConfirmFlag;

  /**
   * 开票状态 0未开票，1部分开票，2完全开具
   */
  @TableField("makeoutStatus")
  private Long makeoutStatus;

  /**
   * 1:正常            0:作废            9:删除
   */
  private Long status;

  /**
   * 业务单修改标记 0-未修改过 0>-修改次数
   */
  @TableField("modifyMark")
  private Long modifyMark;

  /**
   * 是否被修改过，0-未被修改过，1-被修改过
   */
  @TableField("cooperateModifyStatus")
  private Long cooperateModifyStatus;

  /**
   * 原始发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原始发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 原蓝票发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 原蓝票的开票日期
   */
  @TableField("originPaperDrawDate")
  private String originPaperDrawDate;

  /**
   * 红字信息编号
   */
  @TableField("redNotification")
  private String redNotification;

  /**
   * 复核人
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 付款人
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 开票人
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 接收方邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 接收方电话
   */
  @TableField("receiveUserTel")
  private String receiveUserTel;

  /**
   * 创建人
   */
  @TableField("createUser")
  private Long createUser;

  /**
   * 更新人
   */
  @TableField("updateUser")
  private Long updateUser;

  /**
   * 组织机构id
   */
  @TableField("sysOrgId")
  private Long sysOrgId;

  /**
   * 删除的token，每次删除重新赋值
   */
  @TableField("deleteToken")
  private Long deleteToken;

  /**
   * 1:使用中 0:未使用
   */
  @TableField("usingStatus")
  private Long usingStatus;

  /**
   * 客户数据编号
   */
  @TableField("customerNo")
  private String customerNo;

  /**
   * 物流 收件人
   */
  private String addressee;

  /**
   * 物流-收件人电话
   */
  @TableField("addresseeTel")
  private String addresseeTel;

  /**
   * 物流-收件人省份
   */
  @TableField("addresseeProvince")
  private String addresseeProvince;

  /**
   * 物流-收件人城市
   */
  @TableField("addresseeCity")
  private String addresseeCity;

  /**
   * 物流-收件人所在县区
   */
  @TableField("addresseeCounty")
  private String addresseeCounty;

  /**
   * 物流-收件人地址
   */
  private String direction;

  /**
   * 物流备注
   */
  @TableField("logisticRemark")
  private String logisticRemark;

  /**
   * 销方租户id
   */
  @TableField("sellerTenantId")
  private Long sellerTenantId;

  /**
   * 购方租户id
   */
  @TableField("purchaserTenantId")
  private Long purchaserTenantId;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 票面人信息id
   */
  @TableField("operatorId")
  private Long operatorId;

  /**
   * 销方票面抬头id
   */
  @TableField("sellerTitleId")
  private Long sellerTitleId;

  /**
   * 购方票面抬头id
   */
  @TableField("purchaserTitleId")
  private Long purchaserTitleId;

  /**
   * 1:正常状态 2:审批中 3:通过 4:驳回 5:取消审批申请
   */
  @TableField("auditStatus")
  private Long auditStatus;

  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  @TableField("systemOrigType")
  private Long systemOrigType;

  /**
   * 0:正常, 1:申请作废
   */
  @TableField("applyInvalidFlag")
  private Long applyInvalidFlag;

  /**
   * 配单状态 0-待匹配，1-匹配中，2-已匹配，3-匹配冲突, 4-待确认 5-强制匹配
   */
  @TableField("matchStatus")
  private Long matchStatus;

  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   */
  @TableField("makingReason")
  private String makingReason;

  /**
   * 导入的批次号
   */
  @TableField("importBatchNo")
  private String importBatchNo;

  /**
   * 小票日期
   */
  @TableField("posDate")
  private String posDate;

  /**
   * 渠道,中间商租户id
   */
  private Long channel;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 特殊发票标记
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillId", salesbillId);
      map.put("salesbillNo", salesbillNo);
      map.put("originSalesbillNo", originSalesbillNo);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerId", sellerId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserId", purchaserId);
      map.put("businessBillType", businessBillType);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("systemOrig", systemOrig);
      map.put("salesbillType", salesbillType);
      map.put("receiptType", receiptType);
      map.put("invoiceType", invoiceType);
      map.put("priceMethod", priceMethod);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("originAmount", originAmount);
      map.put("taxAmount", taxAmount);
      map.put("alreadyMakeAmountWithTax", alreadyMakeAmountWithTax);
      map.put("alreadyMakeAmountWithoutTax", alreadyMakeAmountWithoutTax);
      map.put("alreadyMakeAmountTaxAmount", alreadyMakeAmountTaxAmount);
      map.put("abandonFreezeAmountWithTax", abandonFreezeAmountWithTax);
      map.put("abandonFreezeAmountWithoutTax", abandonFreezeAmountWithoutTax);
      map.put("abandonFreezeAmountTaxAmount", abandonFreezeAmountTaxAmount);
      map.put("discountWithTaxTotal", discountWithTaxTotal);
      map.put("discountWithoutTaxTotal", discountWithoutTaxTotal);
      map.put("discountTaxAmountTotal", discountTaxAmountTotal);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("outterPrepayAmountWithTax", outterPrepayAmountWithTax);
      map.put("outterPrepayAmountWithoutTax", outterPrepayAmountWithoutTax);
      map.put("innerPrepayAmountWithTax", innerPrepayAmountWithTax);
      map.put("innerPrepayAmountWithoutTax", innerPrepayAmountWithoutTax);
      map.put("cooperateFlag", cooperateFlag);
      map.put("uploadConfirmFlag", uploadConfirmFlag);
      map.put("receiveConfirmFlag", receiveConfirmFlag);
      map.put("makeoutStatus", makeoutStatus);
      map.put("status", status);
      map.put("modifyMark", modifyMark);
      map.put("cooperateModifyStatus", cooperateModifyStatus);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originInvoiceType", originInvoiceType);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("redNotification", redNotification);
      map.put("checkerName", checkerName);
      map.put("cashierName", cashierName);
      map.put("invoicerName", invoicerName);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("receiveUserTel", receiveUserTel);
      map.put("createUser", createUser);
      map.put("updateUser", updateUser);
      map.put("sysOrgId", sysOrgId);
      map.put("deleteToken", deleteToken);
      map.put("usingStatus", usingStatus);
      map.put("customerNo", customerNo);
      map.put("addressee", addressee);
      map.put("addresseeTel", addresseeTel);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("direction", direction);
      map.put("logisticRemark", logisticRemark);
      map.put("sellerTenantId", sellerTenantId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("remark", remark);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("operatorId", operatorId);
      map.put("sellerTitleId", sellerTitleId);
      map.put("purchaserTitleId", purchaserTitleId);
      map.put("auditStatus", auditStatus);
      map.put("systemOrigType", systemOrigType);
      map.put("applyInvalidFlag", applyInvalidFlag);
      map.put("matchStatus", matchStatus);
      map.put("makingReason", makingReason);
      map.put("importBatchNo", importBatchNo);
      map.put("posDate", posDate);
      map.put("channel", channel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      return map;
  }

  public static OrdSalesbill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrdSalesbill entity = new OrdSalesbill();
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesbillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originSalesbillNo")) {
      Object obj = map.get("originSalesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceMethod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPriceMethod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceMethod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originAmount")) {
      Object obj = map.get("originAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMakeAmountWithTax")) {
      Object obj = map.get("alreadyMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMakeAmountWithoutTax")) {
      Object obj = map.get("alreadyMakeAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMakeAmountTaxAmount")) {
      Object obj = map.get("alreadyMakeAmountTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandonFreezeAmountWithTax")) {
      Object obj = map.get("abandonFreezeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAbandonFreezeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandonFreezeAmountWithoutTax")) {
      Object obj = map.get("abandonFreezeAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAbandonFreezeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandonFreezeAmountTaxAmount")) {
      Object obj = map.get("abandonFreezeAmountTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAbandonFreezeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountWithTaxTotal")) {
      Object obj = map.get("discountWithTaxTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountWithTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountWithoutTaxTotal")) {
      Object obj = map.get("discountWithoutTaxTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithoutTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountWithoutTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTaxAmountTotal")) {
      Object obj = map.get("discountTaxAmountTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTaxAmountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountTaxAmountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterPrepayAmountWithTax")) {
      Object obj = map.get("outterPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterPrepayAmountWithoutTax")) {
      Object obj = map.get("outterPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerPrepayAmountWithTax")) {
      Object obj = map.get("innerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerPrepayAmountWithoutTax")) {
      Object obj = map.get("innerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCooperateFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setCooperateFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCooperateFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("uploadConfirmFlag")) {
      Object obj = map.get("uploadConfirmFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUploadConfirmFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setUploadConfirmFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUploadConfirmFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receiveConfirmFlag")) {
      Object obj = map.get("receiveConfirmFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveConfirmFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setReceiveConfirmFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveConfirmFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("makeoutStatus")) {
      Object obj = map.get("makeoutStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeoutStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setMakeoutStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMakeoutStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyMark((Long)obj);
        } else if(obj instanceof String) {
          entity.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cooperateModifyStatus")) {
      Object obj = map.get("cooperateModifyStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCooperateModifyStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setCooperateModifyStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCooperateModifyStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotification")) {
      Object obj = map.get("redNotification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUser((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUser((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deleteToken")) {
      Object obj = map.get("deleteToken");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeleteToken((Long)obj);
        } else if(obj instanceof String) {
          entity.setDeleteToken(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeleteToken(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("usingStatus")) {
      Object obj = map.get("usingStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsingStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsingStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUsingStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operatorId")) {
      Object obj = map.get("operatorId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOperatorId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOperatorId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOperatorId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerTitleId")) {
      Object obj = map.get("sellerTitleId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTitleId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTitleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTitleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTitleId")) {
      Object obj = map.get("purchaserTitleId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTitleId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserTitleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserTitleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setAuditStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuditStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("applyInvalidFlag")) {
      Object obj = map.get("applyInvalidFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyInvalidFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setApplyInvalidFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyInvalidFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setMatchStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("importBatchNo")) {
      Object obj = map.get("importBatchNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImportBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("posDate")) {
      Object obj = map.get("posDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPosDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChannel((Long)obj);
        } else if(obj instanceof String) {
          entity.setChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesbillId((Long)obj);
        } else if(obj instanceof String) {
          this.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originSalesbillNo")) {
      Object obj = map.get("originSalesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceMethod((Long)obj);
        } else if(obj instanceof String) {
          this.setPriceMethod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceMethod(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originAmount")) {
      Object obj = map.get("originAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMakeAmountWithTax")) {
      Object obj = map.get("alreadyMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMakeAmountWithoutTax")) {
      Object obj = map.get("alreadyMakeAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMakeAmountTaxAmount")) {
      Object obj = map.get("alreadyMakeAmountTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAlreadyMakeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandonFreezeAmountWithTax")) {
      Object obj = map.get("abandonFreezeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAbandonFreezeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandonFreezeAmountWithoutTax")) {
      Object obj = map.get("abandonFreezeAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAbandonFreezeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandonFreezeAmountTaxAmount")) {
      Object obj = map.get("abandonFreezeAmountTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAbandonFreezeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountWithTaxTotal")) {
      Object obj = map.get("discountWithTaxTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountWithTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountWithoutTaxTotal")) {
      Object obj = map.get("discountWithoutTaxTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithoutTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountWithoutTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountTaxAmountTotal")) {
      Object obj = map.get("discountTaxAmountTotal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTaxAmountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountTaxAmountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterPrepayAmountWithTax")) {
      Object obj = map.get("outterPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setOutterPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterPrepayAmountWithoutTax")) {
      Object obj = map.get("outterPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setOutterPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerPrepayAmountWithTax")) {
      Object obj = map.get("innerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInnerPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerPrepayAmountWithoutTax")) {
      Object obj = map.get("innerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInnerPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCooperateFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setCooperateFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCooperateFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("uploadConfirmFlag")) {
      Object obj = map.get("uploadConfirmFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUploadConfirmFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setUploadConfirmFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUploadConfirmFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receiveConfirmFlag")) {
      Object obj = map.get("receiveConfirmFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveConfirmFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setReceiveConfirmFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveConfirmFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("makeoutStatus")) {
      Object obj = map.get("makeoutStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMakeoutStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setMakeoutStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMakeoutStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModifyMark((Long)obj);
        } else if(obj instanceof String) {
          this.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cooperateModifyStatus")) {
      Object obj = map.get("cooperateModifyStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCooperateModifyStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setCooperateModifyStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCooperateModifyStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNotification")) {
      Object obj = map.get("redNotification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUser((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUser(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUser((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUser(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSysOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("deleteToken")) {
      Object obj = map.get("deleteToken");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeleteToken((Long)obj);
        } else if(obj instanceof String) {
          this.setDeleteToken(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeleteToken(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("usingStatus")) {
      Object obj = map.get("usingStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUsingStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setUsingStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUsingStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCounty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operatorId")) {
      Object obj = map.get("operatorId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOperatorId((Long)obj);
        } else if(obj instanceof String) {
          this.setOperatorId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOperatorId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sellerTitleId")) {
      Object obj = map.get("sellerTitleId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTitleId((Long)obj);
        } else if(obj instanceof String) {
          this.setSellerTitleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTitleId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTitleId")) {
      Object obj = map.get("purchaserTitleId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserTitleId((Long)obj);
        } else if(obj instanceof String) {
          this.setPurchaserTitleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserTitleId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setAuditStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuditStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String) {
          this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("applyInvalidFlag")) {
      Object obj = map.get("applyInvalidFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyInvalidFlag((Long)obj);
        } else if(obj instanceof String) {
          this.setApplyInvalidFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setApplyInvalidFlag(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMatchStatus((Long)obj);
        } else if(obj instanceof String) {
          this.setMatchStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakingReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("importBatchNo")) {
      Object obj = map.get("importBatchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("posDate")) {
      Object obj = map.get("posDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChannel((Long)obj);
        } else if(obj instanceof String) {
          this.setChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setChannel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
  }
}
