package com.xforceplus.ultraman.app.phoenixkylinservice.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 流程状态
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum FlowStatus {

    SUCCESS("success", "成功"),
    FAILED("failed", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FlowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowStatus fromCode(String code){
        switch(code) {
            case "success":
                return SUCCESS;
            case "failed":
                return FAILED;
            default:
                return null;
        }
    }
}
