package com.xforceplus.ultraman.app.phoenixkylinservice.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 国税发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum TaxInvoiceSource {

    SK("sk", "税控"),
    QD("qd", "全电");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "sk":
                return SK;
            case "qd":
                return QD;
            default:
                return null;
        }
    }
}
