package com.xforceplus.ultraman.app.phoenixkylinservice.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 特殊发票标记
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum SpecialInvoiceFlag {

    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code){
        switch(code) {
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            default:
                return null;
        }
    }
}
