package com.xforceplus.ultraman.app.phoenixkylinservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * inv_seller_pre_invoice
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvSellerPreInvoice implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 批次号
   */
  private Long batchNo;
  /**
   * 系统外批次号  默认batch_no的值
   */
  private Long outBatchNo;
  /**
   * 用户Id 下发数据需要  由属地直接传过来
   */
  private String customerNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 系统来源  下发数据需要  由属地直接传过来
   */
  private String systemOrig;
  /**
   * 业务单号
   */
  private String salesbillNo;
  /**
   * 业务单id
   */
  private Long salesbillId;
  /**
   * 购方集团id
   */
  private Long purchaserTenantId;
  /**
   * 购方租户ID
   */
  private Long purchaserGroupId;
  /**
   * 购方公司id
   */
  private Long purchaserId;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方开户行
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 销方集团id
   */
  private Long sellerTenantId;
  /**
   * 销方租户id
   */
  private Long sellerGroupId;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方开户行
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 销方公司id
   */
  private Long sellerId;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 业务单据类型
   */
  private String businessBillType;
  /**
   * 单据类型
   */
  private String salesbillType;
  /**
   * 开票日期
   */
  private String paperDrawDate;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 价税合计
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 备注
   */
  private String remark;
  /**
   * 收款人
   */
  private String cashierName;
  /**
   * 复核人
   */
  private String checkerName;
  /**
   * 开票人
   */
  private String invoicerName;
  /**
   * 电子签章
   */
  private String electronicSignature;
  /**
   * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
   */
  private Long status;
  /**
   * 业务单修改标记 0-未修改过 0>-修改次数， 这个标记字段从业务单传递过来的
   */
  private Long modifyMark;
  /**
   * 预制发票是否锁定;0=未锁;1=锁定;2=开票锁;3=作废锁(蓝票用)
   */
  private Long lockFlag;
  /**
   * 红票专用 0-红字业务单生成 5-蓝票红冲生成
   */
  private Long redFlag;
  /**
   * 规则id
   */
  private Long ruleId;
  /**
   * 组织机构id
   */
  private Long sysOrgId;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 原蓝票发票类型
   */
  private String originInvoiceType;
  /**
   * 原蓝票的开票日期
   */
  private String originPaperDrawDate;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 接收方邮箱
   */
  private String receiveUserEmail;
  /**
   * 接收方电话
   */
  private String receiveUserTel;
  /**
   * 发票签名 用于抽取匹配
   */
  private String invoiceSignature;
  /**
   * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量) 
   */
  private Long displayPriceQuality;
  /**
   * 销货清单文件打印标志 (0-否, 1-是)
   */
  private Long saleListFileFlag;
  /**
   * 版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用) 
   */
  private Long templateVersion;
  /**
   * 销货清单备注
   */
  private String listGoodsName;
  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   */
  private Long mergeType;
  /**
   * 扩展字段1
   */
  private String ext1;
  /**
   * 扩展字段2
   */
  private String ext2;
  /**
   * 扩展字段3
   */
  private String ext3;
  /**
   * 扩展字段4
   */
  private String ext4;
  /**
   * 扩展字段5
   */
  private String ext5;
  /**
   * 扩展字段6
   */
  private String ext6;
  /**
   * 扩展字段7
   */
  private String ext7;
  /**
   * 扩展字段8
   */
  private String ext8;
  /**
   * 扩展字段9
   */
  private String ext9;
  /**
   * 扩展字段10
   */
  private String ext10;
  /**
   * 扩展字段11
   */
  private String ext11;
  /**
   * 扩展字段12
   */
  private String ext12;
  /**
   * 扩展字段13
   */
  private String ext13;
  /**
   * 扩展字段14
   */
  private String ext14;
  /**
   * 扩展字段15
   */
  private String ext15;
  /**
   * 扩展字段16
   */
  private String ext16;
  /**
   * 扩展字段17
   */
  private String ext17;
  /**
   * 扩展字段18
   */
  private String ext18;
  /**
   * 扩展字段19
   */
  private String ext19;
  /**
   * 扩展字段20
   */
  private String ext20;
  /**
   * 扩展字段21
   */
  private String ext21;
  /**
   * 扩展字段22
   */
  private String ext22;
  /**
   * 扩展字段23
   */
  private String ext23;
  /**
   * 扩展字段24
   */
  private String ext24;
  /**
   * 扩展字段25
   */
  private String ext25;
  /**
   * 物流 收件人
   */
  private String addressee;
  /**
   * 物流-收件人电话
   */
  private String addresseeTel;
  /**
   * 物流-收件人省份
   */
  private String addresseeProvince;
  /**
   * 物流-收件人城市
   */
  private String addresseeCity;
  /**
   * 物流-收件人所在县区
   */
  private String addresseeCounty;
  /**
   * 物流-收件人地址
   */
  private String direction;
  /**
   * 物流备注
   */
  private String logisticRemark;
  /**
   * 收件人所在单位
   */
  private String addresseeComp;
  /**
   * 收件人邮编
   */
  private String addresseePost;
  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  private Long systemOrigType;
  /**
   * 1/0时 代成功与否状态,如果是一串编码代表错误码
   */
  private String processFlag;
  /**
   * 处理备注
   */
  private String processRemark;
  /**
   * 折扣率
   */
  private BigDecimal discountRate;
  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   */
  private String makingReason;
  /**
   * 开票方式 0-否 1-是
   */
  private Long makeType;
  /**
   * 发票票种 s-纸专; se-电专; c-纸普; ce-电普; v-机动车; vs-二手机动车; ju-卷票
   */
  private String invoiceKind;
  /**
   * 税控发票来源 qd-全电发票 sk-税控发票
   */
  private String taxInvoiceSource;
  /**
   * 渠道
   */
  private String channel;
  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 来源
   */
  private String source;
  /**
   * 预制发票ID
   */
  private String preInvoiceId;
  /**
   * 特殊发票标记
   */
  private String specialInvoiceFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("batchNo", batchNo);
      map.put("outBatchNo", outBatchNo);
      map.put("customerNo", customerNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("systemOrig", systemOrig);
      map.put("salesbillNo", salesbillNo);
      map.put("salesbillId", salesbillId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserId", purchaserId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerId", sellerId);
      map.put("invoiceType", invoiceType);
      map.put("businessBillType", businessBillType);
      map.put("salesbillType", salesbillType);
      map.put("paperDrawDate", paperDrawDate);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("electronicSignature", electronicSignature);
      map.put("status", status);
      map.put("modifyMark", modifyMark);
      map.put("lockFlag", lockFlag);
      map.put("redFlag", redFlag);
      map.put("ruleId", ruleId);
      map.put("sysOrgId", sysOrgId);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originInvoiceType", originInvoiceType);
      map.put("originPaperDrawDate", originPaperDrawDate);
      map.put("redNotificationNo", redNotificationNo);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("receiveUserTel", receiveUserTel);
      map.put("invoiceSignature", invoiceSignature);
      map.put("displayPriceQuality", displayPriceQuality);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("templateVersion", templateVersion);
      map.put("listGoodsName", listGoodsName);
      map.put("mergeType", mergeType);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("addressee", addressee);
      map.put("addresseeTel", addresseeTel);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("direction", direction);
      map.put("logisticRemark", logisticRemark);
      map.put("addresseeComp", addresseeComp);
      map.put("addresseePost", addresseePost);
      map.put("systemOrigType", systemOrigType);
      map.put("processFlag", processFlag);
      map.put("processRemark", processRemark);
      map.put("discountRate", discountRate);
      map.put("makingReason", makingReason);
      map.put("makeType", makeType);
      map.put("invoiceKind", invoiceKind);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("channel", channel);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("source", source);
      map.put("preInvoiceId", preInvoiceId);
      map.put("specialInvoiceFlag", specialInvoiceFlag);

      return map;
  }

  public static InvSellerPreInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvSellerPreInvoice entity = new InvSellerPreInvoice();

    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesbillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ruleId")) {
      Object obj = map.get("ruleId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRuleId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRuleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRuleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignature")) {
      Object obj = map.get("invoiceSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("displayPriceQuality")) {
      Object obj = map.get("displayPriceQuality");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDisplayPriceQuality((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDisplayPriceQuality(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDisplayPriceQuality(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("templateVersion")) {
      Object obj = map.get("templateVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTemplateVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTemplateVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTemplateVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("listGoodsName")) {
      Object obj = map.get("listGoodsName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setListGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outBatchNo")) {
      Object obj = map.get("outBatchNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSalesbillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicSignature")) {
      Object obj = map.get("electronicSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("modifyMark")) {
      Object obj = map.get("modifyMark");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setModifyMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRedFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ruleId")) {
      Object obj = map.get("ruleId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRuleId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRuleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRuleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originPaperDrawDate")) {
      Object obj = map.get("originPaperDrawDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserTel")) {
      Object obj = map.get("receiveUserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignature")) {
      Object obj = map.get("invoiceSignature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("displayPriceQuality")) {
      Object obj = map.get("displayPriceQuality");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDisplayPriceQuality((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDisplayPriceQuality(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDisplayPriceQuality(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("templateVersion")) {
      Object obj = map.get("templateVersion");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTemplateVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTemplateVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTemplateVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("listGoodsName")) {
      Object obj = map.get("listGoodsName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setListGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mergeType")) {
      Object obj = map.get("mergeType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeTel")) {
      Object obj = map.get("addresseeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticRemark")) {
      Object obj = map.get("logisticRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeComp")) {
      Object obj = map.get("addresseeComp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePost")) {
      Object obj = map.get("addresseePost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrigType")) {
      Object obj = map.get("systemOrigType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcessFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("makingReason")) {
      Object obj = map.get("makingReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeType")) {
      Object obj = map.get("makeType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPreInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
  }
}
