package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.BillRealLeasehold;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IBillRealLeaseholdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class BillRealLeaseholdController {

  @Autowired
  private IBillRealLeaseholdService billRealLeaseholdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billRealLeasehold ${table.comment}
   * @return
   */
  @GetMapping("/billrealleaseholds" )
  public XfR getBillRealLeaseholds(XfPage page, BillRealLeasehold billRealLeasehold) {
    return XfR.ok(billRealLeaseholdServiceImpl.page(page, Wrappers.query(billRealLeasehold)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billrealleaseholds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billRealLeaseholdServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billRealLeasehold ${table.comment}
   * @return XfR
   */
  @PostMapping("/billrealleaseholds")
  public XfR save(@RequestBody BillRealLeasehold billRealLeasehold) {
     return XfR.ok(billRealLeaseholdServiceImpl.save(billRealLeasehold));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billRealLeasehold ${table.comment}
   * @return XfR
   */
  @PutMapping("/billrealleaseholds/{id}")
  public XfR putUpdate(@RequestBody BillRealLeasehold billRealLeasehold,@PathVariable Long id) {
      billRealLeasehold.setId(id);
      return XfR.ok(billRealLeaseholdServiceImpl.updateById(billRealLeasehold));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billRealLeasehold ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billrealleaseholds/{id}")
  public XfR patchUpdate(@RequestBody BillRealLeasehold billRealLeasehold,@PathVariable Long id) {
      BillRealLeasehold upbillRealLeasehold = billRealLeaseholdServiceImpl.getById(id);
      if(upbillRealLeasehold != null){
        upbillRealLeasehold = ObjectCopyUtils.copyProperties(billRealLeasehold,upbillRealLeasehold,true);
      }
      return XfR.ok(billRealLeaseholdServiceImpl.updateById(upbillRealLeasehold));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billrealleaseholds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billRealLeaseholdServiceImpl.removeById(id));
  }

  @PostMapping("/billrealleaseholds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_real_leasehold");
     params.put("request", condition);

     return XfR.ok(billRealLeaseholdServiceImpl.querys(params));
  }

}
