package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.ConstructionSalesInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IConstructionSalesInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class ConstructionSalesInvoiceController {

  @Autowired
  private IConstructionSalesInvoiceService constructionSalesInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionSalesInvoice ${table.comment}
   * @return
   */
  @GetMapping("/constructionsalesinvoices" )
  public XfR getConstructionSalesInvoices(XfPage page, ConstructionSalesInvoice constructionSalesInvoice) {
    return XfR.ok(constructionSalesInvoiceServiceImpl.page(page, Wrappers.query(constructionSalesInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionsalesinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionSalesInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionSalesInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionsalesinvoices")
  public XfR save(@RequestBody ConstructionSalesInvoice constructionSalesInvoice) {
     return XfR.ok(constructionSalesInvoiceServiceImpl.save(constructionSalesInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionSalesInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionsalesinvoices/{id}")
  public XfR putUpdate(@RequestBody ConstructionSalesInvoice constructionSalesInvoice,@PathVariable Long id) {
      constructionSalesInvoice.setId(id);
      return XfR.ok(constructionSalesInvoiceServiceImpl.updateById(constructionSalesInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionSalesInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionsalesinvoices/{id}")
  public XfR patchUpdate(@RequestBody ConstructionSalesInvoice constructionSalesInvoice,@PathVariable Long id) {
      ConstructionSalesInvoice upconstructionSalesInvoice = constructionSalesInvoiceServiceImpl.getById(id);
      if(upconstructionSalesInvoice != null){
        upconstructionSalesInvoice = ObjectCopyUtils.copyProperties(constructionSalesInvoice,upconstructionSalesInvoice,true);
      }
      return XfR.ok(constructionSalesInvoiceServiceImpl.updateById(upconstructionSalesInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionsalesinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionSalesInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/constructionsalesinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_sales_invoice");
     params.put("request", condition);

     return XfR.ok(constructionSalesInvoiceServiceImpl.querys(params));
  }

}
