package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.ConstructionSalesInvoiceItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IConstructionSalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class ConstructionSalesInvoiceItemController {

  @Autowired
  private IConstructionSalesInvoiceItemService constructionSalesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionSalesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/constructionsalesinvoiceitems" )
  public XfR getConstructionSalesInvoiceItems(XfPage page, ConstructionSalesInvoiceItem constructionSalesInvoiceItem) {
    return XfR.ok(constructionSalesInvoiceItemServiceImpl.page(page, Wrappers.query(constructionSalesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionsalesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionSalesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionsalesinvoiceitems")
  public XfR save(@RequestBody ConstructionSalesInvoiceItem constructionSalesInvoiceItem) {
     return XfR.ok(constructionSalesInvoiceItemServiceImpl.save(constructionSalesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionsalesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody ConstructionSalesInvoiceItem constructionSalesInvoiceItem,@PathVariable Long id) {
      constructionSalesInvoiceItem.setId(id);
      return XfR.ok(constructionSalesInvoiceItemServiceImpl.updateById(constructionSalesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionsalesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody ConstructionSalesInvoiceItem constructionSalesInvoiceItem,@PathVariable Long id) {
      ConstructionSalesInvoiceItem upconstructionSalesInvoiceItem = constructionSalesInvoiceItemServiceImpl.getById(id);
      if(upconstructionSalesInvoiceItem != null){
        upconstructionSalesInvoiceItem = ObjectCopyUtils.copyProperties(constructionSalesInvoiceItem,upconstructionSalesInvoiceItem,true);
      }
      return XfR.ok(constructionSalesInvoiceItemServiceImpl.updateById(upconstructionSalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionsalesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionSalesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/constructionsalesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(constructionSalesInvoiceItemServiceImpl.querys(params));
  }

}
