package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.ConstructionSalesPreInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IConstructionSalesPreInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class ConstructionSalesPreInvoiceController {

  @Autowired
  private IConstructionSalesPreInvoiceService constructionSalesPreInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionSalesPreInvoice ${table.comment}
   * @return
   */
  @GetMapping("/constructionsalespreinvoices" )
  public XfR getConstructionSalesPreInvoices(XfPage page, ConstructionSalesPreInvoice constructionSalesPreInvoice) {
    return XfR.ok(constructionSalesPreInvoiceServiceImpl.page(page, Wrappers.query(constructionSalesPreInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionsalespreinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionSalesPreInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionsalespreinvoices")
  public XfR save(@RequestBody ConstructionSalesPreInvoice constructionSalesPreInvoice) {
     return XfR.ok(constructionSalesPreInvoiceServiceImpl.save(constructionSalesPreInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionsalespreinvoices/{id}")
  public XfR putUpdate(@RequestBody ConstructionSalesPreInvoice constructionSalesPreInvoice,@PathVariable Long id) {
      constructionSalesPreInvoice.setId(id);
      return XfR.ok(constructionSalesPreInvoiceServiceImpl.updateById(constructionSalesPreInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionsalespreinvoices/{id}")
  public XfR patchUpdate(@RequestBody ConstructionSalesPreInvoice constructionSalesPreInvoice,@PathVariable Long id) {
      ConstructionSalesPreInvoice upconstructionSalesPreInvoice = constructionSalesPreInvoiceServiceImpl.getById(id);
      if(upconstructionSalesPreInvoice != null){
        upconstructionSalesPreInvoice = ObjectCopyUtils.copyProperties(constructionSalesPreInvoice,upconstructionSalesPreInvoice,true);
      }
      return XfR.ok(constructionSalesPreInvoiceServiceImpl.updateById(upconstructionSalesPreInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionsalespreinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionSalesPreInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/constructionsalespreinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_sales_pre_invoice");
     params.put("request", condition);

     return XfR.ok(constructionSalesPreInvoiceServiceImpl.querys(params));
  }

}
