package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.ConstructionSalesPreInvoiceItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IConstructionSalesPreInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class ConstructionSalesPreInvoiceItemController {

  @Autowired
  private IConstructionSalesPreInvoiceItemService constructionSalesPreInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionSalesPreInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/constructionsalespreinvoiceitems" )
  public XfR getConstructionSalesPreInvoiceItems(XfPage page, ConstructionSalesPreInvoiceItem constructionSalesPreInvoiceItem) {
    return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.page(page, Wrappers.query(constructionSalesPreInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionsalespreinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionsalespreinvoiceitems")
  public XfR save(@RequestBody ConstructionSalesPreInvoiceItem constructionSalesPreInvoiceItem) {
     return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.save(constructionSalesPreInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionsalespreinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody ConstructionSalesPreInvoiceItem constructionSalesPreInvoiceItem,@PathVariable Long id) {
      constructionSalesPreInvoiceItem.setId(id);
      return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.updateById(constructionSalesPreInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionsalespreinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody ConstructionSalesPreInvoiceItem constructionSalesPreInvoiceItem,@PathVariable Long id) {
      ConstructionSalesPreInvoiceItem upconstructionSalesPreInvoiceItem = constructionSalesPreInvoiceItemServiceImpl.getById(id);
      if(upconstructionSalesPreInvoiceItem != null){
        upconstructionSalesPreInvoiceItem = ObjectCopyUtils.copyProperties(constructionSalesPreInvoiceItem,upconstructionSalesPreInvoiceItem,true);
      }
      return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.updateById(upconstructionSalesPreInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionsalespreinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/constructionsalespreinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_sales_pre_invoice_item");
     params.put("request", condition);

     return XfR.ok(constructionSalesPreInvoiceItemServiceImpl.querys(params));
  }

}
