package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.FreightSalesageInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IFreightSalesageInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class FreightSalesageInvoiceController {

  @Autowired
  private IFreightSalesageInvoiceService freightSalesageInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightSalesageInvoice ${table.comment}
   * @return
   */
  @GetMapping("/freightsalesageinvoices" )
  public XfR getFreightSalesageInvoices(XfPage page, FreightSalesageInvoice freightSalesageInvoice) {
    return XfR.ok(freightSalesageInvoiceServiceImpl.page(page, Wrappers.query(freightSalesageInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightsalesageinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightSalesageInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightSalesageInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightsalesageinvoices")
  public XfR save(@RequestBody FreightSalesageInvoice freightSalesageInvoice) {
     return XfR.ok(freightSalesageInvoiceServiceImpl.save(freightSalesageInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightSalesageInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightsalesageinvoices/{id}")
  public XfR putUpdate(@RequestBody FreightSalesageInvoice freightSalesageInvoice,@PathVariable Long id) {
      freightSalesageInvoice.setId(id);
      return XfR.ok(freightSalesageInvoiceServiceImpl.updateById(freightSalesageInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightSalesageInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightsalesageinvoices/{id}")
  public XfR patchUpdate(@RequestBody FreightSalesageInvoice freightSalesageInvoice,@PathVariable Long id) {
      FreightSalesageInvoice upfreightSalesageInvoice = freightSalesageInvoiceServiceImpl.getById(id);
      if(upfreightSalesageInvoice != null){
        upfreightSalesageInvoice = ObjectCopyUtils.copyProperties(freightSalesageInvoice,upfreightSalesageInvoice,true);
      }
      return XfR.ok(freightSalesageInvoiceServiceImpl.updateById(upfreightSalesageInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightsalesageinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightSalesageInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/freightsalesageinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freight_salesage_invoice");
     params.put("request", condition);

     return XfR.ok(freightSalesageInvoiceServiceImpl.querys(params));
  }

}
