package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.FreightSalesagePreInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IFreightSalesagePreInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class FreightSalesagePreInvoiceController {

  @Autowired
  private IFreightSalesagePreInvoiceService freightSalesagePreInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightSalesagePreInvoice ${table.comment}
   * @return
   */
  @GetMapping("/freightsalesagepreinvoices" )
  public XfR getFreightSalesagePreInvoices(XfPage page, FreightSalesagePreInvoice freightSalesagePreInvoice) {
    return XfR.ok(freightSalesagePreInvoiceServiceImpl.page(page, Wrappers.query(freightSalesagePreInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightsalesagepreinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightSalesagePreInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightSalesagePreInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightsalesagepreinvoices")
  public XfR save(@RequestBody FreightSalesagePreInvoice freightSalesagePreInvoice) {
     return XfR.ok(freightSalesagePreInvoiceServiceImpl.save(freightSalesagePreInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightSalesagePreInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightsalesagepreinvoices/{id}")
  public XfR putUpdate(@RequestBody FreightSalesagePreInvoice freightSalesagePreInvoice,@PathVariable Long id) {
      freightSalesagePreInvoice.setId(id);
      return XfR.ok(freightSalesagePreInvoiceServiceImpl.updateById(freightSalesagePreInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightSalesagePreInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightsalesagepreinvoices/{id}")
  public XfR patchUpdate(@RequestBody FreightSalesagePreInvoice freightSalesagePreInvoice,@PathVariable Long id) {
      FreightSalesagePreInvoice upfreightSalesagePreInvoice = freightSalesagePreInvoiceServiceImpl.getById(id);
      if(upfreightSalesagePreInvoice != null){
        upfreightSalesagePreInvoice = ObjectCopyUtils.copyProperties(freightSalesagePreInvoice,upfreightSalesagePreInvoice,true);
      }
      return XfR.ok(freightSalesagePreInvoiceServiceImpl.updateById(upfreightSalesagePreInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightsalesagepreinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightSalesagePreInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/freightsalesagepreinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freight_salesage_pre_invoice");
     params.put("request", condition);

     return XfR.ok(freightSalesagePreInvoiceServiceImpl.querys(params));
  }

}
