package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.FreightageAdditionBillItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IFreightageAdditionBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class FreightageAdditionBillItemController {

  @Autowired
  private IFreightageAdditionBillItemService freightageAdditionBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightageAdditionBillItem ${table.comment}
   * @return
   */
  @GetMapping("/freightageadditionbillitems" )
  public XfR getFreightageAdditionBillItems(XfPage page, FreightageAdditionBillItem freightageAdditionBillItem) {
    return XfR.ok(freightageAdditionBillItemServiceImpl.page(page, Wrappers.query(freightageAdditionBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightageadditionbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightageAdditionBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightageAdditionBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightageadditionbillitems")
  public XfR save(@RequestBody FreightageAdditionBillItem freightageAdditionBillItem) {
     return XfR.ok(freightageAdditionBillItemServiceImpl.save(freightageAdditionBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightageAdditionBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightageadditionbillitems/{id}")
  public XfR putUpdate(@RequestBody FreightageAdditionBillItem freightageAdditionBillItem,@PathVariable Long id) {
      freightageAdditionBillItem.setId(id);
      return XfR.ok(freightageAdditionBillItemServiceImpl.updateById(freightageAdditionBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightageAdditionBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightageadditionbillitems/{id}")
  public XfR patchUpdate(@RequestBody FreightageAdditionBillItem freightageAdditionBillItem,@PathVariable Long id) {
      FreightageAdditionBillItem upfreightageAdditionBillItem = freightageAdditionBillItemServiceImpl.getById(id);
      if(upfreightageAdditionBillItem != null){
        upfreightageAdditionBillItem = ObjectCopyUtils.copyProperties(freightageAdditionBillItem,upfreightageAdditionBillItem,true);
      }
      return XfR.ok(freightageAdditionBillItemServiceImpl.updateById(upfreightageAdditionBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightageadditionbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightageAdditionBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/freightageadditionbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freightage_addition_bill_item");
     params.put("request", condition);

     return XfR.ok(freightageAdditionBillItemServiceImpl.querys(params));
  }

}
