package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvSellerPreInvoiceItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvSellerPreInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 4.0前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class InvSellerPreInvoiceItemController {

  @Autowired
  private IInvSellerPreInvoiceItemService invSellerPreInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerPreInvoiceItem 4.0
   * @return
   */
  @GetMapping("/invsellerpreinvoiceitems" )
  public XfR getInvSellerPreInvoiceItems(XfPage page, InvSellerPreInvoiceItem invSellerPreInvoiceItem) {
    return XfR.ok(invSellerPreInvoiceItemServiceImpl.page(page, Wrappers.query(invSellerPreInvoiceItem)));
  }

  /**
   * 通过id查询4.0
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerpreinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerPreInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增4.0
   * @param invSellerPreInvoiceItem 4.0
   * @return XfR
   */
  @PostMapping("/invsellerpreinvoiceitems")
  public XfR save(@RequestBody InvSellerPreInvoiceItem invSellerPreInvoiceItem) {
     return XfR.ok(invSellerPreInvoiceItemServiceImpl.save(invSellerPreInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据4.0
   * @param invSellerPreInvoiceItem 4.0
   * @return XfR
   */
  @PutMapping("/invsellerpreinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody InvSellerPreInvoiceItem invSellerPreInvoiceItem,@PathVariable Long id) {
      invSellerPreInvoiceItem.setId(id);
      return XfR.ok(invSellerPreInvoiceItemServiceImpl.updateById(invSellerPreInvoiceItem));
  }

  /**
   * 修改-传入修改的数据4.0
   * @param invSellerPreInvoiceItem 4.0
   * @return XfR
   */
  @PatchMapping("/invsellerpreinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody InvSellerPreInvoiceItem invSellerPreInvoiceItem,@PathVariable Long id) {
      InvSellerPreInvoiceItem upinvSellerPreInvoiceItem = invSellerPreInvoiceItemServiceImpl.getById(id);
      if(upinvSellerPreInvoiceItem != null){
        upinvSellerPreInvoiceItem = ObjectCopyUtils.copyProperties(invSellerPreInvoiceItem,upinvSellerPreInvoiceItem,true);
      }
      return XfR.ok(invSellerPreInvoiceItemServiceImpl.updateById(upinvSellerPreInvoiceItem));
  }

  /**
   * 通过id删除4.0
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerpreinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerPreInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerpreinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_pre_invoice_item");
     params.put("request", condition);

     return XfR.ok(invSellerPreInvoiceItemServiceImpl.querys(params));
  }

}
