package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvoiceFreightage;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvoiceFreightageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class InvoiceFreightageController {

  @Autowired
  private IInvoiceFreightageService invoiceFreightageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceFreightage ${table.comment}
   * @return
   */
  @GetMapping("/invoicefreightages" )
  public XfR getInvoiceFreightages(XfPage page, InvoiceFreightage invoiceFreightage) {
    return XfR.ok(invoiceFreightageServiceImpl.page(page, Wrappers.query(invoiceFreightage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicefreightages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceFreightageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceFreightage ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicefreightages")
  public XfR save(@RequestBody InvoiceFreightage invoiceFreightage) {
     return XfR.ok(invoiceFreightageServiceImpl.save(invoiceFreightage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceFreightage ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicefreightages/{id}")
  public XfR putUpdate(@RequestBody InvoiceFreightage invoiceFreightage,@PathVariable Long id) {
      invoiceFreightage.setId(id);
      return XfR.ok(invoiceFreightageServiceImpl.updateById(invoiceFreightage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceFreightage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicefreightages/{id}")
  public XfR patchUpdate(@RequestBody InvoiceFreightage invoiceFreightage,@PathVariable Long id) {
      InvoiceFreightage upinvoiceFreightage = invoiceFreightageServiceImpl.getById(id);
      if(upinvoiceFreightage != null){
        upinvoiceFreightage = ObjectCopyUtils.copyProperties(invoiceFreightage,upinvoiceFreightage,true);
      }
      return XfR.ok(invoiceFreightageServiceImpl.updateById(upinvoiceFreightage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicefreightages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceFreightageServiceImpl.removeById(id));
  }

  @PostMapping("/invoicefreightages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_freightage");
     params.put("request", condition);

     return XfR.ok(invoiceFreightageServiceImpl.querys(params));
  }

}
