package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvoiceFreightageItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvoiceFreightageItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class InvoiceFreightageItemController {

  @Autowired
  private IInvoiceFreightageItemService invoiceFreightageItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceFreightageItem ${table.comment}
   * @return
   */
  @GetMapping("/invoicefreightageitems" )
  public XfR getInvoiceFreightageItems(XfPage page, InvoiceFreightageItem invoiceFreightageItem) {
    return XfR.ok(invoiceFreightageItemServiceImpl.page(page, Wrappers.query(invoiceFreightageItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicefreightageitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceFreightageItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicefreightageitems")
  public XfR save(@RequestBody InvoiceFreightageItem invoiceFreightageItem) {
     return XfR.ok(invoiceFreightageItemServiceImpl.save(invoiceFreightageItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicefreightageitems/{id}")
  public XfR putUpdate(@RequestBody InvoiceFreightageItem invoiceFreightageItem,@PathVariable Long id) {
      invoiceFreightageItem.setId(id);
      return XfR.ok(invoiceFreightageItemServiceImpl.updateById(invoiceFreightageItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicefreightageitems/{id}")
  public XfR patchUpdate(@RequestBody InvoiceFreightageItem invoiceFreightageItem,@PathVariable Long id) {
      InvoiceFreightageItem upinvoiceFreightageItem = invoiceFreightageItemServiceImpl.getById(id);
      if(upinvoiceFreightageItem != null){
        upinvoiceFreightageItem = ObjectCopyUtils.copyProperties(invoiceFreightageItem,upinvoiceFreightageItem,true);
      }
      return XfR.ok(invoiceFreightageItemServiceImpl.updateById(upinvoiceFreightageItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicefreightageitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceFreightageItemServiceImpl.removeById(id));
  }

  @PostMapping("/invoicefreightageitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_freightage_item");
     params.put("request", condition);

     return XfR.ok(invoiceFreightageItemServiceImpl.querys(params));
  }

}
