package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.PreInvoiceFreightageItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IPreInvoiceFreightageItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class PreInvoiceFreightageItemController {

  @Autowired
  private IPreInvoiceFreightageItemService preInvoiceFreightageItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preInvoiceFreightageItem ${table.comment}
   * @return
   */
  @GetMapping("/preinvoicefreightageitems" )
  public XfR getPreInvoiceFreightageItems(XfPage page, PreInvoiceFreightageItem preInvoiceFreightageItem) {
    return XfR.ok(preInvoiceFreightageItemServiceImpl.page(page, Wrappers.query(preInvoiceFreightageItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/preinvoicefreightageitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preInvoiceFreightageItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preInvoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/preinvoicefreightageitems")
  public XfR save(@RequestBody PreInvoiceFreightageItem preInvoiceFreightageItem) {
     return XfR.ok(preInvoiceFreightageItemServiceImpl.save(preInvoiceFreightageItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preInvoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/preinvoicefreightageitems/{id}")
  public XfR putUpdate(@RequestBody PreInvoiceFreightageItem preInvoiceFreightageItem,@PathVariable Long id) {
      preInvoiceFreightageItem.setId(id);
      return XfR.ok(preInvoiceFreightageItemServiceImpl.updateById(preInvoiceFreightageItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preInvoiceFreightageItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/preinvoicefreightageitems/{id}")
  public XfR patchUpdate(@RequestBody PreInvoiceFreightageItem preInvoiceFreightageItem,@PathVariable Long id) {
      PreInvoiceFreightageItem uppreInvoiceFreightageItem = preInvoiceFreightageItemServiceImpl.getById(id);
      if(uppreInvoiceFreightageItem != null){
        uppreInvoiceFreightageItem = ObjectCopyUtils.copyProperties(preInvoiceFreightageItem,uppreInvoiceFreightageItem,true);
      }
      return XfR.ok(preInvoiceFreightageItemServiceImpl.updateById(uppreInvoiceFreightageItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/preinvoicefreightageitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preInvoiceFreightageItemServiceImpl.removeById(id));
  }

  @PostMapping("/preinvoicefreightageitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pre_invoice_freightage_item");
     params.put("request", condition);

     return XfR.ok(preInvoiceFreightageItemServiceImpl.querys(params));
  }

}
