package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealEstateSalesBill;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealEstateSalesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealEstateSalesBillController {

  @Autowired
  private IRealEstateSalesBillService realEstateSalesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesBill ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalesbills" )
  public XfR getRealEstateSalesBills(XfPage page, RealEstateSalesBill realEstateSalesBill) {
    return XfR.ok(realEstateSalesBillServiceImpl.page(page, Wrappers.query(realEstateSalesBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalesbills")
  public XfR save(@RequestBody RealEstateSalesBill realEstateSalesBill) {
     return XfR.ok(realEstateSalesBillServiceImpl.save(realEstateSalesBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalesbills/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesBill realEstateSalesBill,@PathVariable Long id) {
      realEstateSalesBill.setId(id);
      return XfR.ok(realEstateSalesBillServiceImpl.updateById(realEstateSalesBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalesbills/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesBill realEstateSalesBill,@PathVariable Long id) {
      RealEstateSalesBill uprealEstateSalesBill = realEstateSalesBillServiceImpl.getById(id);
      if(uprealEstateSalesBill != null){
        uprealEstateSalesBill = ObjectCopyUtils.copyProperties(realEstateSalesBill,uprealEstateSalesBill,true);
      }
      return XfR.ok(realEstateSalesBillServiceImpl.updateById(uprealEstateSalesBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesBillServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_bill");
     params.put("request", condition);

     return XfR.ok(realEstateSalesBillServiceImpl.querys(params));
  }

}
