package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealEstateSalesBillItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealEstateSalesBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealEstateSalesBillItemController {

  @Autowired
  private IRealEstateSalesBillItemService realEstateSalesBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesBillItem ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalesbillitems" )
  public XfR getRealEstateSalesBillItems(XfPage page, RealEstateSalesBillItem realEstateSalesBillItem) {
    return XfR.ok(realEstateSalesBillItemServiceImpl.page(page, Wrappers.query(realEstateSalesBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalesbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalesbillitems")
  public XfR save(@RequestBody RealEstateSalesBillItem realEstateSalesBillItem) {
     return XfR.ok(realEstateSalesBillItemServiceImpl.save(realEstateSalesBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalesbillitems/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesBillItem realEstateSalesBillItem,@PathVariable Long id) {
      realEstateSalesBillItem.setId(id);
      return XfR.ok(realEstateSalesBillItemServiceImpl.updateById(realEstateSalesBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalesbillitems/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesBillItem realEstateSalesBillItem,@PathVariable Long id) {
      RealEstateSalesBillItem uprealEstateSalesBillItem = realEstateSalesBillItemServiceImpl.getById(id);
      if(uprealEstateSalesBillItem != null){
        uprealEstateSalesBillItem = ObjectCopyUtils.copyProperties(realEstateSalesBillItem,uprealEstateSalesBillItem,true);
      }
      return XfR.ok(realEstateSalesBillItemServiceImpl.updateById(uprealEstateSalesBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalesbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalesbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_bill_item");
     params.put("request", condition);

     return XfR.ok(realEstateSalesBillItemServiceImpl.querys(params));
  }

}
