package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealEstateSalesPreInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealEstateSalesPreInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealEstateSalesPreInvoiceController {

  @Autowired
  private IRealEstateSalesPreInvoiceService realEstateSalesPreInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesPreInvoice ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalespreinvoices" )
  public XfR getRealEstateSalesPreInvoices(XfPage page, RealEstateSalesPreInvoice realEstateSalesPreInvoice) {
    return XfR.ok(realEstateSalesPreInvoiceServiceImpl.page(page, Wrappers.query(realEstateSalesPreInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalespreinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesPreInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalespreinvoices")
  public XfR save(@RequestBody RealEstateSalesPreInvoice realEstateSalesPreInvoice) {
     return XfR.ok(realEstateSalesPreInvoiceServiceImpl.save(realEstateSalesPreInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalespreinvoices/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesPreInvoice realEstateSalesPreInvoice,@PathVariable Long id) {
      realEstateSalesPreInvoice.setId(id);
      return XfR.ok(realEstateSalesPreInvoiceServiceImpl.updateById(realEstateSalesPreInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesPreInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalespreinvoices/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesPreInvoice realEstateSalesPreInvoice,@PathVariable Long id) {
      RealEstateSalesPreInvoice uprealEstateSalesPreInvoice = realEstateSalesPreInvoiceServiceImpl.getById(id);
      if(uprealEstateSalesPreInvoice != null){
        uprealEstateSalesPreInvoice = ObjectCopyUtils.copyProperties(realEstateSalesPreInvoice,uprealEstateSalesPreInvoice,true);
      }
      return XfR.ok(realEstateSalesPreInvoiceServiceImpl.updateById(uprealEstateSalesPreInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalespreinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesPreInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalespreinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_pre_invoice");
     params.put("request", condition);

     return XfR.ok(realEstateSalesPreInvoiceServiceImpl.querys(params));
  }

}
