package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealEstateSalesPreInvoiceItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealEstateSalesPreInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealEstateSalesPreInvoiceItemController {

  @Autowired
  private IRealEstateSalesPreInvoiceItemService realEstateSalesPreInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesPreInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalespreinvoiceitems" )
  public XfR getRealEstateSalesPreInvoiceItems(XfPage page, RealEstateSalesPreInvoiceItem realEstateSalesPreInvoiceItem) {
    return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.page(page, Wrappers.query(realEstateSalesPreInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalespreinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalespreinvoiceitems")
  public XfR save(@RequestBody RealEstateSalesPreInvoiceItem realEstateSalesPreInvoiceItem) {
     return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.save(realEstateSalesPreInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalespreinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesPreInvoiceItem realEstateSalesPreInvoiceItem,@PathVariable Long id) {
      realEstateSalesPreInvoiceItem.setId(id);
      return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.updateById(realEstateSalesPreInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalespreinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesPreInvoiceItem realEstateSalesPreInvoiceItem,@PathVariable Long id) {
      RealEstateSalesPreInvoiceItem uprealEstateSalesPreInvoiceItem = realEstateSalesPreInvoiceItemServiceImpl.getById(id);
      if(uprealEstateSalesPreInvoiceItem != null){
        uprealEstateSalesPreInvoiceItem = ObjectCopyUtils.copyProperties(realEstateSalesPreInvoiceItem,uprealEstateSalesPreInvoiceItem,true);
      }
      return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.updateById(uprealEstateSalesPreInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalespreinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalespreinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_pre_invoice_item");
     params.put("request", condition);

     return XfR.ok(realEstateSalesPreInvoiceItemServiceImpl.querys(params));
  }

}
