package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealLeaseholdBillItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealLeaseholdBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealLeaseholdBillItemController {

  @Autowired
  private IRealLeaseholdBillItemService realLeaseholdBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdBillItem ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdbillitems" )
  public XfR getRealLeaseholdBillItems(XfPage page, RealLeaseholdBillItem realLeaseholdBillItem) {
    return XfR.ok(realLeaseholdBillItemServiceImpl.page(page, Wrappers.query(realLeaseholdBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdbillitems")
  public XfR save(@RequestBody RealLeaseholdBillItem realLeaseholdBillItem) {
     return XfR.ok(realLeaseholdBillItemServiceImpl.save(realLeaseholdBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdbillitems/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdBillItem realLeaseholdBillItem,@PathVariable Long id) {
      realLeaseholdBillItem.setId(id);
      return XfR.ok(realLeaseholdBillItemServiceImpl.updateById(realLeaseholdBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdbillitems/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdBillItem realLeaseholdBillItem,@PathVariable Long id) {
      RealLeaseholdBillItem uprealLeaseholdBillItem = realLeaseholdBillItemServiceImpl.getById(id);
      if(uprealLeaseholdBillItem != null){
        uprealLeaseholdBillItem = ObjectCopyUtils.copyProperties(realLeaseholdBillItem,uprealLeaseholdBillItem,true);
      }
      return XfR.ok(realLeaseholdBillItemServiceImpl.updateById(uprealLeaseholdBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_bill_item");
     params.put("request", condition);

     return XfR.ok(realLeaseholdBillItemServiceImpl.querys(params));
  }

}
