package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealLeaseholdInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealLeaseholdInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealLeaseholdInvoiceController {

  @Autowired
  private IRealLeaseholdInvoiceService realLeaseholdInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdInvoice ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdinvoices" )
  public XfR getRealLeaseholdInvoices(XfPage page, RealLeaseholdInvoice realLeaseholdInvoice) {
    return XfR.ok(realLeaseholdInvoiceServiceImpl.page(page, Wrappers.query(realLeaseholdInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdinvoices")
  public XfR save(@RequestBody RealLeaseholdInvoice realLeaseholdInvoice) {
     return XfR.ok(realLeaseholdInvoiceServiceImpl.save(realLeaseholdInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdinvoices/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdInvoice realLeaseholdInvoice,@PathVariable Long id) {
      realLeaseholdInvoice.setId(id);
      return XfR.ok(realLeaseholdInvoiceServiceImpl.updateById(realLeaseholdInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdinvoices/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdInvoice realLeaseholdInvoice,@PathVariable Long id) {
      RealLeaseholdInvoice uprealLeaseholdInvoice = realLeaseholdInvoiceServiceImpl.getById(id);
      if(uprealLeaseholdInvoice != null){
        uprealLeaseholdInvoice = ObjectCopyUtils.copyProperties(realLeaseholdInvoice,uprealLeaseholdInvoice,true);
      }
      return XfR.ok(realLeaseholdInvoiceServiceImpl.updateById(uprealLeaseholdInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_invoice");
     params.put("request", condition);

     return XfR.ok(realLeaseholdInvoiceServiceImpl.querys(params));
  }

}
