package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RealLeaseholdInvoiceItem;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRealLeaseholdInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-26
 */
@RestController
public class RealLeaseholdInvoiceItemController {

  @Autowired
  private IRealLeaseholdInvoiceItemService realLeaseholdInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdinvoiceitems" )
  public XfR getRealLeaseholdInvoiceItems(XfPage page, RealLeaseholdInvoiceItem realLeaseholdInvoiceItem) {
    return XfR.ok(realLeaseholdInvoiceItemServiceImpl.page(page, Wrappers.query(realLeaseholdInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdinvoiceitems")
  public XfR save(@RequestBody RealLeaseholdInvoiceItem realLeaseholdInvoiceItem) {
     return XfR.ok(realLeaseholdInvoiceItemServiceImpl.save(realLeaseholdInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdInvoiceItem realLeaseholdInvoiceItem,@PathVariable Long id) {
      realLeaseholdInvoiceItem.setId(id);
      return XfR.ok(realLeaseholdInvoiceItemServiceImpl.updateById(realLeaseholdInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdInvoiceItem realLeaseholdInvoiceItem,@PathVariable Long id) {
      RealLeaseholdInvoiceItem uprealLeaseholdInvoiceItem = realLeaseholdInvoiceItemServiceImpl.getById(id);
      if(uprealLeaseholdInvoiceItem != null){
        uprealLeaseholdInvoiceItem = ObjectCopyUtils.copyProperties(realLeaseholdInvoiceItem,uprealLeaseholdInvoiceItem,true);
      }
      return XfR.ok(realLeaseholdInvoiceItemServiceImpl.updateById(uprealLeaseholdInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_invoice_item");
     params.put("request", condition);

     return XfR.ok(realLeaseholdInvoiceItemServiceImpl.querys(params));
  }

}
