package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.BillConstructionServices;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IBillConstructionServicesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-31
 */
@RestController
public class BillConstructionServicesController {

  @Autowired
  private IBillConstructionServicesService billConstructionServicesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billConstructionServices ${table.comment}
   * @return
   */
  @GetMapping("/billconstructionservicess" )
  public XfR getBillConstructionServicess(XfPage page, BillConstructionServices billConstructionServices) {
    return XfR.ok(billConstructionServicesServiceImpl.page(page, Wrappers.query(billConstructionServices)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billconstructionservicess/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billConstructionServicesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billConstructionServices ${table.comment}
   * @return XfR
   */
  @PostMapping("/billconstructionservicess")
  public XfR save(@RequestBody BillConstructionServices billConstructionServices) {
     return XfR.ok(billConstructionServicesServiceImpl.save(billConstructionServices));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billConstructionServices ${table.comment}
   * @return XfR
   */
  @PutMapping("/billconstructionservicess/{id}")
  public XfR putUpdate(@RequestBody BillConstructionServices billConstructionServices,@PathVariable Long id) {
      billConstructionServices.setId(id);
      return XfR.ok(billConstructionServicesServiceImpl.updateById(billConstructionServices));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billConstructionServices ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billconstructionservicess/{id}")
  public XfR patchUpdate(@RequestBody BillConstructionServices billConstructionServices,@PathVariable Long id) {
      BillConstructionServices upbillConstructionServices = billConstructionServicesServiceImpl.getById(id);
      if(upbillConstructionServices != null){
        upbillConstructionServices = ObjectCopyUtils.copyProperties(billConstructionServices,upbillConstructionServices,true);
      }
      return XfR.ok(billConstructionServicesServiceImpl.updateById(upbillConstructionServices));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billconstructionservicess/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billConstructionServicesServiceImpl.removeById(id));
  }

  @PostMapping("/billconstructionservicess/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_construction_services");
     params.put("request", condition);

     return XfR.ok(billConstructionServicesServiceImpl.querys(params));
  }

}
