package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.BillRealEstateSales;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IBillRealEstateSalesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-31
 */
@RestController
public class BillRealEstateSalesController {

  @Autowired
  private IBillRealEstateSalesService billRealEstateSalesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billRealEstateSales ${table.comment}
   * @return
   */
  @GetMapping("/billrealestatesaless" )
  public XfR getBillRealEstateSaless(XfPage page, BillRealEstateSales billRealEstateSales) {
    return XfR.ok(billRealEstateSalesServiceImpl.page(page, Wrappers.query(billRealEstateSales)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billrealestatesaless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billRealEstateSalesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billRealEstateSales ${table.comment}
   * @return XfR
   */
  @PostMapping("/billrealestatesaless")
  public XfR save(@RequestBody BillRealEstateSales billRealEstateSales) {
     return XfR.ok(billRealEstateSalesServiceImpl.save(billRealEstateSales));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billRealEstateSales ${table.comment}
   * @return XfR
   */
  @PutMapping("/billrealestatesaless/{id}")
  public XfR putUpdate(@RequestBody BillRealEstateSales billRealEstateSales,@PathVariable Long id) {
      billRealEstateSales.setId(id);
      return XfR.ok(billRealEstateSalesServiceImpl.updateById(billRealEstateSales));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billRealEstateSales ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billrealestatesaless/{id}")
  public XfR patchUpdate(@RequestBody BillRealEstateSales billRealEstateSales,@PathVariable Long id) {
      BillRealEstateSales upbillRealEstateSales = billRealEstateSalesServiceImpl.getById(id);
      if(upbillRealEstateSales != null){
        upbillRealEstateSales = ObjectCopyUtils.copyProperties(billRealEstateSales,upbillRealEstateSales,true);
      }
      return XfR.ok(billRealEstateSalesServiceImpl.updateById(upbillRealEstateSales));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billrealestatesaless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billRealEstateSalesServiceImpl.removeById(id));
  }

  @PostMapping("/billrealestatesaless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_real_estate_sales");
     params.put("request", condition);

     return XfR.ok(billRealEstateSalesServiceImpl.querys(params));
  }

}
