package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvSellerInvoice;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvSellerInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 4.0前端控制器
 *
 * @author ultraman
 * @date 2024-01-31
 */
@RestController
public class InvSellerInvoiceController {

  @Autowired
  private IInvSellerInvoiceService invSellerInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerInvoice 4.0
   * @return
   */
  @GetMapping("/invsellerinvoices" )
  public XfR getInvSellerInvoices(XfPage page, InvSellerInvoice invSellerInvoice) {
    return XfR.ok(invSellerInvoiceServiceImpl.page(page, Wrappers.query(invSellerInvoice)));
  }

  /**
   * 通过id查询4.0
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增4.0
   * @param invSellerInvoice 4.0
   * @return XfR
   */
  @PostMapping("/invsellerinvoices")
  public XfR save(@RequestBody InvSellerInvoice invSellerInvoice) {
     return XfR.ok(invSellerInvoiceServiceImpl.save(invSellerInvoice));
  }

  /**
   * 修改-传入修改后的全部数据4.0
   * @param invSellerInvoice 4.0
   * @return XfR
   */
  @PutMapping("/invsellerinvoices/{id}")
  public XfR putUpdate(@RequestBody InvSellerInvoice invSellerInvoice,@PathVariable Long id) {
      invSellerInvoice.setId(id);
      return XfR.ok(invSellerInvoiceServiceImpl.updateById(invSellerInvoice));
  }

  /**
   * 修改-传入修改的数据4.0
   * @param invSellerInvoice 4.0
   * @return XfR
   */
  @PatchMapping("/invsellerinvoices/{id}")
  public XfR patchUpdate(@RequestBody InvSellerInvoice invSellerInvoice,@PathVariable Long id) {
      InvSellerInvoice upinvSellerInvoice = invSellerInvoiceServiceImpl.getById(id);
      if(upinvSellerInvoice != null){
        upinvSellerInvoice = ObjectCopyUtils.copyProperties(invSellerInvoice,upinvSellerInvoice,true);
      }
      return XfR.ok(invSellerInvoiceServiceImpl.updateById(upinvSellerInvoice));
  }

  /**
   * 通过id删除4.0
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_invoice");
     params.put("request", condition);

     return XfR.ok(invSellerInvoiceServiceImpl.querys(params));
  }

}
