package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvoiceConstructionServices;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvoiceConstructionServicesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-31
 */
@RestController
public class InvoiceConstructionServicesController {

  @Autowired
  private IInvoiceConstructionServicesService invoiceConstructionServicesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceConstructionServices ${table.comment}
   * @return
   */
  @GetMapping("/invoiceconstructionservicess" )
  public XfR getInvoiceConstructionServicess(XfPage page, InvoiceConstructionServices invoiceConstructionServices) {
    return XfR.ok(invoiceConstructionServicesServiceImpl.page(page, Wrappers.query(invoiceConstructionServices)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceconstructionservicess/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceConstructionServicesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceConstructionServices ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceconstructionservicess")
  public XfR save(@RequestBody InvoiceConstructionServices invoiceConstructionServices) {
     return XfR.ok(invoiceConstructionServicesServiceImpl.save(invoiceConstructionServices));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceConstructionServices ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceconstructionservicess/{id}")
  public XfR putUpdate(@RequestBody InvoiceConstructionServices invoiceConstructionServices,@PathVariable Long id) {
      invoiceConstructionServices.setId(id);
      return XfR.ok(invoiceConstructionServicesServiceImpl.updateById(invoiceConstructionServices));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceConstructionServices ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceconstructionservicess/{id}")
  public XfR patchUpdate(@RequestBody InvoiceConstructionServices invoiceConstructionServices,@PathVariable Long id) {
      InvoiceConstructionServices upinvoiceConstructionServices = invoiceConstructionServicesServiceImpl.getById(id);
      if(upinvoiceConstructionServices != null){
        upinvoiceConstructionServices = ObjectCopyUtils.copyProperties(invoiceConstructionServices,upinvoiceConstructionServices,true);
      }
      return XfR.ok(invoiceConstructionServicesServiceImpl.updateById(upinvoiceConstructionServices));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceconstructionservicess/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceConstructionServicesServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceconstructionservicess/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_construction_services");
     params.put("request", condition);

     return XfR.ok(invoiceConstructionServicesServiceImpl.querys(params));
  }

}
