package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.InvoiceRealLeasehold;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IInvoiceRealLeaseholdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-31
 */
@RestController
public class InvoiceRealLeaseholdController {

  @Autowired
  private IInvoiceRealLeaseholdService invoiceRealLeaseholdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRealLeasehold ${table.comment}
   * @return
   */
  @GetMapping("/invoicerealleaseholds" )
  public XfR getInvoiceRealLeaseholds(XfPage page, InvoiceRealLeasehold invoiceRealLeasehold) {
    return XfR.ok(invoiceRealLeaseholdServiceImpl.page(page, Wrappers.query(invoiceRealLeasehold)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerealleaseholds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRealLeaseholdServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceRealLeasehold ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicerealleaseholds")
  public XfR save(@RequestBody InvoiceRealLeasehold invoiceRealLeasehold) {
     return XfR.ok(invoiceRealLeaseholdServiceImpl.save(invoiceRealLeasehold));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceRealLeasehold ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicerealleaseholds/{id}")
  public XfR putUpdate(@RequestBody InvoiceRealLeasehold invoiceRealLeasehold,@PathVariable Long id) {
      invoiceRealLeasehold.setId(id);
      return XfR.ok(invoiceRealLeaseholdServiceImpl.updateById(invoiceRealLeasehold));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceRealLeasehold ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicerealleaseholds/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRealLeasehold invoiceRealLeasehold,@PathVariable Long id) {
      InvoiceRealLeasehold upinvoiceRealLeasehold = invoiceRealLeaseholdServiceImpl.getById(id);
      if(upinvoiceRealLeasehold != null){
        upinvoiceRealLeasehold = ObjectCopyUtils.copyProperties(invoiceRealLeasehold,upinvoiceRealLeasehold,true);
      }
      return XfR.ok(invoiceRealLeaseholdServiceImpl.updateById(upinvoiceRealLeasehold));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerealleaseholds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRealLeaseholdServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerealleaseholds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_real_leasehold");
     params.put("request", condition);

     return XfR.ok(invoiceRealLeaseholdServiceImpl.querys(params));
  }

}
