package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.AbandonProduct;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IAbandonProductService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-21
 */
@RestController
public class AbandonProductController {

  @Autowired
  private IAbandonProductService abandonProductServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param abandonProduct ${table.comment}
   * @return
   */
  @GetMapping("/abandonproducts" )
  public XfR getAbandonProducts(XfPage page, AbandonProduct abandonProduct) {
    return XfR.ok(abandonProductServiceImpl.page(page, Wrappers.query(abandonProduct)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/abandonproducts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(abandonProductServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param abandonProduct ${table.comment}
   * @return XfR
   */
  @PostMapping("/abandonproducts")
  public XfR save(@RequestBody AbandonProduct abandonProduct) {
     return XfR.ok(abandonProductServiceImpl.save(abandonProduct));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param abandonProduct ${table.comment}
   * @return XfR
   */
  @PutMapping("/abandonproducts/{id}")
  public XfR putUpdate(@RequestBody AbandonProduct abandonProduct,@PathVariable Long id) {
      abandonProduct.setId(id);
      return XfR.ok(abandonProductServiceImpl.updateById(abandonProduct));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param abandonProduct ${table.comment}
   * @return XfR
   */
  @PatchMapping("/abandonproducts/{id}")
  public XfR patchUpdate(@RequestBody AbandonProduct abandonProduct,@PathVariable Long id) {
      AbandonProduct upabandonProduct = abandonProductServiceImpl.getById(id);
      if(upabandonProduct != null){
        upabandonProduct = ObjectCopyUtils.copyProperties(abandonProduct,upabandonProduct,true);
      }
      return XfR.ok(abandonProductServiceImpl.updateById(upabandonProduct));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/abandonproducts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(abandonProductServiceImpl.removeById(id));
  }

  @PostMapping("/abandonproducts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "abandon_product");
     params.put("request", condition);

     return XfR.ok(abandonProductServiceImpl.querys(params));
  }

}
