package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.BillFreightage;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IBillFreightageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-21
 */
@RestController
public class BillFreightageController {

  @Autowired
  private IBillFreightageService billFreightageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billFreightage ${table.comment}
   * @return
   */
  @GetMapping("/billfreightages" )
  public XfR getBillFreightages(XfPage page, BillFreightage billFreightage) {
    return XfR.ok(billFreightageServiceImpl.page(page, Wrappers.query(billFreightage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billfreightages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billFreightageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billFreightage ${table.comment}
   * @return XfR
   */
  @PostMapping("/billfreightages")
  public XfR save(@RequestBody BillFreightage billFreightage) {
     return XfR.ok(billFreightageServiceImpl.save(billFreightage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billFreightage ${table.comment}
   * @return XfR
   */
  @PutMapping("/billfreightages/{id}")
  public XfR putUpdate(@RequestBody BillFreightage billFreightage,@PathVariable Long id) {
      billFreightage.setId(id);
      return XfR.ok(billFreightageServiceImpl.updateById(billFreightage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billFreightage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billfreightages/{id}")
  public XfR patchUpdate(@RequestBody BillFreightage billFreightage,@PathVariable Long id) {
      BillFreightage upbillFreightage = billFreightageServiceImpl.getById(id);
      if(upbillFreightage != null){
        upbillFreightage = ObjectCopyUtils.copyProperties(billFreightage,upbillFreightage,true);
      }
      return XfR.ok(billFreightageServiceImpl.updateById(upbillFreightage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billfreightages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billFreightageServiceImpl.removeById(id));
  }

  @PostMapping("/billfreightages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_freightage");
     params.put("request", condition);

     return XfR.ok(billFreightageServiceImpl.querys(params));
  }

}
