package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.OrdSalesbill;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IOrdSalesbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 4.0前端控制器
 *
 * @author ultraman
 * @date 2024-08-21
 */
@RestController
public class OrdSalesbillController {

  @Autowired
  private IOrdSalesbillService ordSalesbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbill 4.0
   * @return
   */
  @GetMapping("/ordsalesbills" )
  public XfR getOrdSalesbills(XfPage page, OrdSalesbill ordSalesbill) {
    return XfR.ok(ordSalesbillServiceImpl.page(page, Wrappers.query(ordSalesbill)));
  }

  /**
   * 通过id查询4.0
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillServiceImpl.getById(id));
  }

  /**
   * 新增4.0
   * @param ordSalesbill 4.0
   * @return XfR
   */
  @PostMapping("/ordsalesbills")
  public XfR save(@RequestBody OrdSalesbill ordSalesbill) {
     return XfR.ok(ordSalesbillServiceImpl.save(ordSalesbill));
  }

  /**
   * 修改-传入修改后的全部数据4.0
   * @param ordSalesbill 4.0
   * @return XfR
   */
  @PutMapping("/ordsalesbills/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbill ordSalesbill,@PathVariable Long id) {
      ordSalesbill.setId(id);
      return XfR.ok(ordSalesbillServiceImpl.updateById(ordSalesbill));
  }

  /**
   * 修改-传入修改的数据4.0
   * @param ordSalesbill 4.0
   * @return XfR
   */
  @PatchMapping("/ordsalesbills/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbill ordSalesbill,@PathVariable Long id) {
      OrdSalesbill upordSalesbill = ordSalesbillServiceImpl.getById(id);
      if(upordSalesbill != null){
        upordSalesbill = ObjectCopyUtils.copyProperties(ordSalesbill,upordSalesbill,true);
      }
      return XfR.ok(ordSalesbillServiceImpl.updateById(upordSalesbill));
  }

  /**
   * 通过id删除4.0
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ord_salesbill");
     params.put("request", condition);

     return XfR.ok(ordSalesbillServiceImpl.querys(params));
  }

}
