package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.RegionEnums;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IRegionEnumsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 统一管理全电省市区信息前端控制器
 *
 * @author ultraman
 * @date 2024-08-21
 */
@RestController
public class RegionEnumsController {

  @Autowired
  private IRegionEnumsService regionEnumsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param regionEnums 统一管理全电省市区信息
   * @return
   */
  @GetMapping("/regionenumss" )
  public XfR getRegionEnumss(XfPage page, RegionEnums regionEnums) {
    return XfR.ok(regionEnumsServiceImpl.page(page, Wrappers.query(regionEnums)));
  }

  /**
   * 通过id查询统一管理全电省市区信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/regionenumss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(regionEnumsServiceImpl.getById(id));
  }

  /**
   * 新增统一管理全电省市区信息
   * @param regionEnums 统一管理全电省市区信息
   * @return XfR
   */
  @PostMapping("/regionenumss")
  public XfR save(@RequestBody RegionEnums regionEnums) {
     return XfR.ok(regionEnumsServiceImpl.save(regionEnums));
  }

  /**
   * 修改-传入修改后的全部数据统一管理全电省市区信息
   * @param regionEnums 统一管理全电省市区信息
   * @return XfR
   */
  @PutMapping("/regionenumss/{id}")
  public XfR putUpdate(@RequestBody RegionEnums regionEnums,@PathVariable Long id) {
      regionEnums.setId(id);
      return XfR.ok(regionEnumsServiceImpl.updateById(regionEnums));
  }

  /**
   * 修改-传入修改的数据统一管理全电省市区信息
   * @param regionEnums 统一管理全电省市区信息
   * @return XfR
   */
  @PatchMapping("/regionenumss/{id}")
  public XfR patchUpdate(@RequestBody RegionEnums regionEnums,@PathVariable Long id) {
      RegionEnums upregionEnums = regionEnumsServiceImpl.getById(id);
      if(upregionEnums != null){
        upregionEnums = ObjectCopyUtils.copyProperties(regionEnums,upregionEnums,true);
      }
      return XfR.ok(regionEnumsServiceImpl.updateById(upregionEnums));
  }

  /**
   * 通过id删除统一管理全电省市区信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/regionenumss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(regionEnumsServiceImpl.removeById(id));
  }

  @PostMapping("/regionenumss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "region_enums");
     params.put("request", condition);

     return XfR.ok(regionEnumsServiceImpl.querys(params));
  }

}
